/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime.memory;

import java.util.Collection;
import org.evrete.api.ReIterator;
import org.evrete.api.RuntimeFact;
import org.evrete.api.spi.SharedPlainFactStorage;
import org.evrete.runtime.PlainMemory;
import org.evrete.runtime.RuntimeObject;
import org.evrete.runtime.evaluation.AlphaBucketMeta;
import org.evrete.runtime.memory.SessionMemory;

class TypeMemoryBucket
implements PlainMemory {
    private final SharedPlainFactStorage data;
    private final SharedPlainFactStorage delta;
    private final AlphaBucketMeta alphaMask;

    TypeMemoryBucket(SessionMemory runtime, AlphaBucketMeta alphaMask) {
        assert (!alphaMask.isEmpty());
        this.data = runtime.getConfiguration().getCollectionsService().newPlainStorage();
        this.delta = runtime.getConfiguration().getCollectionsService().newPlainStorage();
        this.alphaMask = alphaMask;
    }

    void clear() {
        this.data.clear();
        this.delta.clear();
    }

    void fillMainStorage(ReIterator<RuntimeObject> iterator) {
        if (iterator.reset() > 0L) {
            while (iterator.hasNext()) {
                RuntimeObject rto = (RuntimeObject)iterator.next();
                if (!this.alphaMask.test(rto)) continue;
                this.data.insert(rto);
            }
        }
    }

    @Override
    public boolean hasChanges() {
        return this.delta.size() > 0;
    }

    @Override
    public ReIterator<RuntimeFact> mainIterator() {
        return this.data.iterator();
    }

    @Override
    public ReIterator<RuntimeFact> deltaIterator() {
        return this.delta.iterator();
    }

    @Override
    public void commitChanges() {
        int deltaSize = this.delta.size();
        if (deltaSize > 0) {
            this.data.ensureExtraCapacity(deltaSize);
            this.delta.iterator().forEachRemaining(this.data::insert);
            this.delta.clear();
        }
    }

    void insert(Collection<RuntimeObject> facts) {
        this.delta.ensureExtraCapacity(facts.size());
        for (RuntimeObject rto : facts) {
            if (!this.alphaMask.test(rto)) continue;
            this.delta.insert(rto);
        }
    }

    void retract(Collection<RuntimeFact> facts) {
        for (RuntimeFact fact : facts) {
            if (!this.alphaMask.test(fact)) continue;
            this.data.delete(fact);
        }
    }
}

