/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.spi.minimal;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.ToolProvider;
import org.evrete.api.Type;
import org.evrete.spi.minimal.JcClassLoader;
import org.evrete.spi.minimal.JcCompilationException;
import org.evrete.spi.minimal.JcFileManager;
import org.evrete.spi.minimal.JcJavaSource;
import org.evrete.spi.minimal.TypeImpl;

class JcCompiler {
    private static final Logger LOGGER = Logger.getLogger(JcCompiler.class.getName());
    private static final String FUNCTION_NAME = Function.class.getName();
    private static final String FIELD_NAME = "FUNC";
    private static final String FIELD_TEMPLATE = "package %s;\npublic interface %s {\n  %s<%s, Object> %s =\n    %s\n}\n";
    private static final AtomicInteger counter = new AtomicInteger();
    private final String packageName;
    private final JcClassLoader classLoader;
    private final Map<Type, Map<String, Function<?, ?>>> compiledLambdas = new HashMap();
    private final JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
    private int globalId = 0;

    public JcCompiler(ClassLoader classLoader) {
        this.classLoader = new JcClassLoader(classLoader);
        this.packageName = JcCompiler.class.getPackage().getName() + ".p" + counter.incrementAndGet();
    }

    public final Function<?, ?> compileLambda(TypeImpl type, String exp) {
        String lambda = exp.trim();
        lambda = lambda.endsWith(";") ? lambda : lambda + ';';
        Function function = (Function)this.compiledLambdas.computeIfAbsent(type, k -> new HashMap()).get(lambda);
        if (function == null) {
            String className = "F" + this.globalId++;
            String source = String.format(FIELD_TEMPLATE, this.packageName, className, FUNCTION_NAME, type.getClazz().getName(), FIELD_NAME, lambda);
            Class<?> compiled = this.compile(className, source);
            try {
                function = (Function)compiled.getField(FIELD_NAME).get(null);
                this.compiledLambdas.get(type).put(lambda, function);
            }
            catch (JcCompilationException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new JcCompilationException(e);
            }
        }
        return function;
    }

    public Class<?> compile(String className, String source) {
        long t0 = Calendar.getInstance().getTimeInMillis();
        try {
            byte[] bytes = this.compileSourceToClassBytes(className, source);
            Class<?> clazz = this.classLoader.buildClass(className, bytes);
            return clazz;
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Failed to compile source:\n" + source, e);
            throw new JcCompilationException(e);
        }
        finally {
            long t1 = Calendar.getInstance().getTimeInMillis();
            LOGGER.fine("Compile time: " + (t1 - t0) + "ms, source: " + source);
        }
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    private byte[] compileSourceToClassBytes(String className, String source) {
        boolean success;
        JcFileManager<?> fileManager = JcFileManager.instance(this.compiler, this.classLoader.getParent());
        DiagnosticCollector diagnostics = new DiagnosticCollector();
        try {
            success = this.compiler.getTask(null, fileManager, diagnostics, null, null, JcJavaSource.task(className, source)).call();
        }
        catch (Throwable t) {
            throw new JcCompilationException(t.getCause());
        }
        if (success) {
            return fileManager.getBytes();
        }
        ArrayList<String> errors = new ArrayList<String>();
        for (Diagnostic diagnostic : diagnostics.getDiagnostics()) {
            if (diagnostic.getKind() != Diagnostic.Kind.ERROR) continue;
            errors.add(diagnostic.toString());
        }
        throw new JcCompilationException("Unknown compilation error: " + errors);
    }
}

