/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.spi.minimal;

import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import javax.tools.JavaFileObject;
import org.evrete.spi.minimal.JcJavaFileObject;

class JcPackageInternalsFinder {
    private static final String CLASS_FILE_EXTENSION = ".class";
    private final ClassLoader classLoader;

    JcPackageInternalsFinder(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    private static Collection<JavaFileObject> listUnder(String packageName, URL packageFolderURL) {
        File directory = new File(packageFolderURL.getFile());
        if (directory.isDirectory()) {
            return JcPackageInternalsFinder.processDir(packageName, directory);
        }
        return JcPackageInternalsFinder.processJar(packageFolderURL);
    }

    private static List<JavaFileObject> processJar(URL packageFolderURL) {
        ArrayList<JavaFileObject> result = new ArrayList<JavaFileObject>();
        try {
            String jarUri = packageFolderURL.toExternalForm().split("!")[0];
            JarURLConnection jarConn = (JarURLConnection)packageFolderURL.openConnection();
            String rootEntryName = jarConn.getEntryName();
            int rootEnd = rootEntryName.length() + 1;
            Enumeration<JarEntry> entryEnum = jarConn.getJarFile().entries();
            while (entryEnum.hasMoreElements()) {
                JarEntry jarEntry = entryEnum.nextElement();
                String name = jarEntry.getName();
                if (!name.startsWith(rootEntryName) || name.indexOf(47, rootEnd) != -1 || !name.endsWith(CLASS_FILE_EXTENSION)) continue;
                URI uri = URI.create(jarUri + "!/" + name);
                String binaryName = name.replaceAll("/", ".");
                binaryName = binaryName.replaceAll(".class$", "");
                result.add(new JcJavaFileObject(binaryName, uri));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Wasn't able to open " + packageFolderURL + " as a jar file", e);
        }
        return result;
    }

    private static List<JavaFileObject> processDir(String packageName, File directory) {
        ArrayList<JavaFileObject> result = new ArrayList<JavaFileObject>();
        File[] childFiles = directory.listFiles();
        if (childFiles == null) {
            return result;
        }
        for (File childFile : childFiles) {
            if (!childFile.isFile() || !childFile.getName().endsWith(CLASS_FILE_EXTENSION)) continue;
            String binaryName = packageName + '.' + childFile.getName();
            binaryName = binaryName.replaceAll(".class$", "");
            result.add(new JcJavaFileObject(binaryName, childFile.toURI()));
        }
        return result;
    }

    public List<JavaFileObject> find(String packageName) throws IOException {
        String javaPackageName = packageName.replaceAll("\\.", "/");
        ArrayList<JavaFileObject> result = new ArrayList<JavaFileObject>();
        Enumeration<URL> urlEnumeration = this.classLoader.getResources(javaPackageName);
        while (urlEnumeration.hasMoreElements()) {
            URL packageFolderURL = urlEnumeration.nextElement();
            result.addAll(JcPackageInternalsFinder.listUnder(packageName, packageFolderURL));
        }
        return result;
    }
}

