/*
 * Decompiled with CFR 0.152.
 */
package org.evrete;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import java.util.ServiceLoader;
import org.evrete.api.spi.CollectionsService;
import org.evrete.api.spi.CollectionsServiceProvider;
import org.evrete.api.spi.ExpressionResolver;
import org.evrete.api.spi.ExpressionResolverProvider;
import org.evrete.api.spi.ResolverService;
import org.evrete.api.spi.ResolverServiceProvider;

public class Configuration {
    private static final boolean DEFAULT_WARN_UNKNOWN_TYPES = true;
    private final ClassLoader classLoader;
    private final CollectionsService collectionsService;
    private final ExpressionResolver expressionResolver;
    private final ResolverService resolverService;
    private boolean warnUnknownTypes = true;

    private Configuration(ClassLoader classLoader, Properties properties) {
        this.classLoader = classLoader;
        this.collectionsService = Configuration.loadService(CollectionsServiceProvider.class).instance(properties);
        this.expressionResolver = Configuration.loadService(ExpressionResolverProvider.class).instance(properties, classLoader);
        this.resolverService = Configuration.loadService(ResolverServiceProvider.class).instance();
    }

    public Configuration() {
        this(Thread.currentThread().getContextClassLoader(), new Properties());
    }

    private static <Z extends Comparable<Z>> Z loadService(Class<Z> clazz) {
        LinkedList providers = new LinkedList();
        Iterator<Z> sl = ServiceLoader.load(clazz).iterator();
        sl.forEachRemaining(providers::add);
        Collections.sort(providers);
        if (providers.isEmpty()) {
            throw new IllegalStateException();
        }
        return (Z)((Comparable)providers.iterator().next());
    }

    public boolean isWarnUnknownTypes() {
        return this.warnUnknownTypes;
    }

    public Configuration setWarnUnknownTypes(boolean warnUnknownTypes) {
        this.warnUnknownTypes = warnUnknownTypes;
        return this;
    }

    public ResolverService getResolverService() {
        return this.resolverService;
    }

    public CollectionsService getCollectionsService() {
        return this.collectionsService;
    }

    public ExpressionResolver getExpressionsService() {
        return this.expressionResolver;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }
}

