/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.api;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import org.evrete.api.ActiveField;
import org.evrete.api.Type;

public final class FieldsKey {
    private static final Comparator<ActiveField> ZERO_ARR_COMPARATOR = (o1, o2) -> 0;
    private static final Comparator<ActiveField> DEFAULT_COMPARATOR = Comparator.comparing(ActiveField::getValueIndex);
    private final ActiveField[] fields;
    private final Type type;

    public FieldsKey(Type type, Collection<ActiveField> collection) {
        this(type, collection.toArray(ActiveField.ZERO_ARRAY), DEFAULT_COMPARATOR);
    }

    private FieldsKey(Type type, ActiveField[] arr, Comparator<ActiveField> comparator) {
        this.fields = arr;
        Arrays.sort(this.fields, comparator);
        this.type = type;
    }

    public Type getType() {
        return this.type;
    }

    public int size() {
        return this.fields.length;
    }

    public ActiveField[] getFields() {
        return this.fields;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldsKey that = (FieldsKey)o;
        return this.type.equals(that.type) && Arrays.equals(this.fields, that.fields);
    }

    public int hashCode() {
        return Arrays.hashCode(this.fields);
    }

    public String toString() {
        return this.type.getName() + Arrays.toString(this.fields);
    }
}

