/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.collections;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.function.IntConsumer;
import java.util.function.IntPredicate;
import java.util.stream.IntStream;
import org.evrete.collections.ArrayBulkCleanupData;
import org.evrete.util.CollectionUtils;

public class UnsignedIntArray {
    private static final int NULL_VALUE = -1;
    private int[] unsignedIndices;
    protected int currentInsertIndex;

    public UnsignedIntArray(int initialSize) {
        this.unsignedIndices = (int[])Array.newInstance(Integer.TYPE, Math.max(initialSize, 1));
        CollectionUtils.systemFill(this.unsignedIndices, -1);
        this.currentInsertIndex = 0;
    }

    private static int optimalArrayLen(int dataSize) {
        switch (dataSize) {
            case 0: 
            case 1: {
                return 2;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 5;
            }
        }
        return (dataSize + 1) * 3 / 2;
    }

    public void addNew(int value) {
        if (this.currentInsertIndex == this.unsignedIndices.length - 1) {
            this.expand();
        }
        this.unsignedIndices[this.currentInsertIndex++] = value;
    }

    protected int getAt(int pos) {
        return this.unsignedIndices[pos];
    }

    void clear() {
        this.currentInsertIndex = 0;
    }

    public int currentInsertIndex() {
        return this.currentInsertIndex;
    }

    int dataSize() {
        return this.unsignedIndices.length;
    }

    void copyFrom(UnsignedIntArray other) {
        this.unsignedIndices = other.unsignedIndices;
        this.currentInsertIndex = other.currentInsertIndex;
    }

    public void forEachInt(IntConsumer consumer) {
        for (int i = 0; i < this.currentInsertIndex; ++i) {
            int idx = this.unsignedIndices[i];
            consumer.accept(idx);
        }
    }

    IntStream intStream() {
        return Arrays.stream(this.unsignedIndices, 0, this.currentInsertIndex);
    }

    public boolean delete(IntPredicate predicate) {
        if (this.currentInsertIndex == 0) {
            return false;
        }
        ArrayBulkCleanupData rs = new ArrayBulkCleanupData(this.currentInsertIndex);
        int deletedEntries = rs.clean(this.unsignedIndices, predicate);
        if (deletedEntries > 0) {
            CollectionUtils.systemFill(this.unsignedIndices, this.currentInsertIndex - deletedEntries, this.currentInsertIndex, -1);
            this.currentInsertIndex -= deletedEntries;
            this.shrink();
            return true;
        }
        return false;
    }

    private void expand() {
        int newLen = UnsignedIntArray.optimalArrayLen(this.unsignedIndices.length);
        this.unsignedIndices = Arrays.copyOf(this.unsignedIndices, newLen);
        CollectionUtils.systemFill(this.unsignedIndices, this.currentInsertIndex, newLen, -1);
    }

    public String toString() {
        return "{data=" + Arrays.toString(this.unsignedIndices) + ", currentIndex=" + this.currentInsertIndex + '}';
    }

    private void shrink() {
        int optimal = UnsignedIntArray.optimalArrayLen(this.currentInsertIndex);
        if (this.currentInsertIndex < optimal) {
            this.unsignedIndices = Arrays.copyOf(this.unsignedIndices, optimal);
        }
    }
}

