/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.evrete.api.Rule;
import org.evrete.api.RuntimeRule;
import org.evrete.runtime.RuleDescriptor;
import org.evrete.runtime.RuntimeAggregateLhsJoined;
import org.evrete.runtime.RuntimeRuleImpl;
import org.evrete.runtime.memory.SessionMemory;

public class RuntimeRules
implements Iterable<RuntimeRuleImpl> {
    private final List<RuntimeRuleImpl> list = new ArrayList<RuntimeRuleImpl>();
    private final Collection<RuntimeAggregateLhsJoined> aggregateLhsGroups = new ArrayList<RuntimeAggregateLhsJoined>();
    private final SessionMemory runtime;

    public RuntimeRules(SessionMemory runtime) {
        this.runtime = runtime;
    }

    private void add(RuntimeRuleImpl rule) {
        this.list.add(rule);
        this.aggregateLhsGroups.addAll(rule.getLhs().getAggregateConditionedGroups());
    }

    public RuntimeRuleImpl addRule(RuleDescriptor ruleDescriptor) {
        RuntimeRuleImpl r = new RuntimeRuleImpl(ruleDescriptor, this.runtime);
        this.add(r);
        return r;
    }

    public void sort(Comparator<Rule> comparator) {
        this.list.sort(comparator);
    }

    public Collection<RuntimeAggregateLhsJoined> getAggregateLhsGroups() {
        return this.aggregateLhsGroups;
    }

    @Override
    public Iterator<RuntimeRuleImpl> iterator() {
        return this.list.iterator();
    }

    public List<RuntimeRule> asList() {
        return Collections.unmodifiableList(this.list);
    }

    public List<RuntimeRule> activeRules() {
        LinkedList<RuntimeRule> l = new LinkedList<RuntimeRule>();
        for (RuntimeRuleImpl rule : this.list) {
            if (!rule.isInActiveState()) continue;
            l.add(rule);
        }
        return l;
    }
}

