/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.util.List;
import org.evrete.api.ActivationManager;
import org.evrete.api.Named;
import org.evrete.api.RuntimeRule;
import org.evrete.api.StatefulSession;
import org.evrete.runtime.ActivationContext;
import org.evrete.runtime.KnowledgeImpl;
import org.evrete.runtime.RuntimeRuleImpl;
import org.evrete.runtime.memory.SessionMemory;

public class StatefulSessionImpl
extends SessionMemory
implements StatefulSession {
    private final KnowledgeImpl knowledge;
    private boolean active = true;
    private ActivationManager activationManager;

    StatefulSessionImpl(KnowledgeImpl knowledge) {
        super(knowledge);
        this.knowledge = knowledge;
        this.activationManager = this.newActivationManager();
    }

    @Override
    public RuntimeRule getRule(String name) {
        return Named.find(this.getRules(), name);
    }

    @Override
    public void close() {
        if (this.active) {
            this.active = false;
            super.destroy();
            this.knowledge.close(this);
        }
    }

    @Override
    public ActivationManager getActivationManager() {
        return this.activationManager;
    }

    @Override
    public void setActivationManager(ActivationManager activationManager) {
        this.activationManager = activationManager;
    }

    @Override
    public void fire() {
        if (this.hasMemoryTasks()) {
            this.fireDefault(new ActivationContext(this));
        }
    }

    private void fireDefault(ActivationContext ctx) {
        this.checkState();
        this.processChanges();
        List<RuntimeRule> agenda = this.getAgenda();
        if (agenda.size() > 0) {
            this.activationManager.onAgenda(ctx.incrementFireCount(), agenda);
            for (RuntimeRule r : this.getAgenda()) {
                RuntimeRuleImpl impl = (RuntimeRuleImpl)r;
                if (this.activationManager.test(impl)) {
                    impl.executeRhs();
                    this.activationManager.onActivation(impl);
                }
                impl.resetState();
            }
        }
        this.commitMemoryDeltas();
        if (this.hasMemoryTasks()) {
            this.fireDefault(ctx);
        }
    }

    private void checkState() {
        if (!this.active) {
            throw new IllegalStateException("Session has been closed");
        }
    }
}

