/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime.async;

import java.util.function.Function;
import java.util.function.Predicate;
import org.evrete.api.IntToValueRow;
import org.evrete.api.ValueRow;
import org.evrete.runtime.FactType;

class ValueRowPredicate
implements Predicate<IntToValueRow> {
    private final FactType[] types;
    private final Function<FactType, Predicate<ValueRow>> function;

    private ValueRowPredicate(FactType[] types, Function<FactType, Predicate<ValueRow>> function) {
        this.types = types;
        this.function = function;
    }

    static ValueRowPredicate[] predicates(FactType[][] grouping, Function<FactType, Predicate<ValueRow>> function) {
        ValueRowPredicate[] predicates = new ValueRowPredicate[grouping.length];
        for (int level = 0; level < grouping.length; ++level) {
            FactType[] types = grouping[level];
            predicates[level] = new ValueRowPredicate(types, function);
        }
        return predicates;
    }

    @Override
    public boolean test(IntToValueRow intToValueRow) {
        boolean delete = false;
        for (int typeId = 0; typeId < this.types.length; ++typeId) {
            FactType type = this.types[typeId];
            Predicate<ValueRow> criteria = this.function.apply(type);
            boolean match = criteria != null && criteria.test(intToValueRow.apply(typeId));
            delete |= match;
        }
        return delete;
    }
}

