/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.spi.minimal;

import java.util.Arrays;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.evrete.api.IntToValueRow;
import org.evrete.api.KeysStore;
import org.evrete.api.ValueRow;
import org.evrete.spi.minimal.AbstractKeysStore;
import org.evrete.spi.minimal.KeysStoreEntry;
import org.evrete.spi.minimal.MiscUtils;

class KeysStoreMap
extends AbstractKeysStore<MapEntry> {
    private final Supplier<KeysStore> storeSupplier;

    KeysStoreMap(int level, int arrSize, Supplier<KeysStore> storeSupplier) {
        super(level, arrSize);
        this.storeSupplier = storeSupplier;
    }

    @Override
    public final <P extends Predicate<IntToValueRow>> void delete(P[] predicates, int index) {
        for (int i = 0; i < this.currentInsertIndex; ++i) {
            int idx = this.getAt(i);
            MapEntry entry = (MapEntry)this.get(idx);
            if (entry == null) continue;
            entry.next.delete((Predicate[])predicates, index + 1);
            ValueRow[] arr = entry.key;
            IntToValueRow iv = z -> arr[z];
            if (!predicates[index].test((IntToValueRow)iv) && !entry.next.isEmpty()) continue;
            this.markDeleted(idx);
        }
    }

    @Override
    public final void save(IntFunction<IntToValueRow> values) {
        this.resize();
        ValueRow[] key = MiscUtils.toArray(values.apply(this.level), this.arrSize);
        int hash = MiscUtils.hash(key);
        int addr = this.findBinIndex(key, hash, EQ_FUNCTION);
        MapEntry found = (MapEntry)this.get(addr);
        if (found == null) {
            found = new MapEntry(key, hash, this.storeSupplier.get());
            this.saveDirect(found, addr);
        }
        found.next.save(values);
    }

    @Override
    public final void append(KeysStore other) {
        this.bulkAdd((KeysStoreMap)other);
    }

    static final class MapEntry
    extends KeysStoreEntry {
        final KeysStore next;

        MapEntry(ValueRow[] key, int hash, KeysStore next) {
            super(key, hash);
            this.next = next;
        }

        @Override
        public final KeysStore getNext() {
            return this.next;
        }

        public String toString() {
            return Arrays.toString(this.key) + "->" + this.next;
        }
    }
}

