/*
 * Decompiled with CFR 0.152.
 */
package org.evrete;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ServiceLoader;
import org.evrete.Configuration;
import org.evrete.api.Knowledge;
import org.evrete.api.OrderedServiceProvider;
import org.evrete.api.spi.ExpressionResolverProvider;
import org.evrete.api.spi.LiteralRhsCompiler;
import org.evrete.api.spi.MemoryCollectionsProvider;
import org.evrete.api.spi.TypeResolverProvider;
import org.evrete.runtime.KnowledgeImpl;
import org.evrete.runtime.async.ForkJoinExecutor;

public class KnowledgeService {
    private final Configuration configuration;
    private final ForkJoinExecutor executor = new ForkJoinExecutor();
    private final MemoryCollectionsProvider collectionsServiceProvider;
    private final ExpressionResolverProvider expressionResolverProvider;
    private final TypeResolverProvider typeResolverProvider;
    private final LiteralRhsCompiler literalRhsProvider;
    private ClassLoader classLoader;

    public KnowledgeService(Configuration configuration) {
        this.configuration = configuration;
        this.collectionsServiceProvider = KnowledgeService.loadService(MemoryCollectionsProvider.class);
        this.expressionResolverProvider = KnowledgeService.loadService(ExpressionResolverProvider.class);
        this.typeResolverProvider = KnowledgeService.loadService(TypeResolverProvider.class);
        this.literalRhsProvider = KnowledgeService.loadService(LiteralRhsCompiler.class);
        this.classLoader = Thread.currentThread().getContextClassLoader();
    }

    public KnowledgeService() {
        this(new Configuration());
    }

    private static <Z extends OrderedServiceProvider> Z loadService(Class<Z> clazz) {
        LinkedList providers = new LinkedList();
        Iterator<Z> sl = ServiceLoader.load(clazz).iterator();
        sl.forEachRemaining(providers::add);
        Collections.sort(providers);
        if (providers.isEmpty()) {
            throw new IllegalStateException("Implementation missing: " + clazz);
        }
        return (Z)((OrderedServiceProvider)providers.iterator().next());
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public Knowledge newKnowledge() {
        return new KnowledgeImpl(this);
    }

    public void shutdown() {
        this.executor.shutdown();
    }

    public ForkJoinExecutor getExecutor() {
        return this.executor;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public MemoryCollectionsProvider getCollectionsServiceProvider() {
        return this.collectionsServiceProvider;
    }

    public ExpressionResolverProvider getExpressionResolverProvider() {
        return this.expressionResolverProvider;
    }

    public LiteralRhsCompiler getLiteralRhsProvider() {
        return this.literalRhsProvider;
    }

    public TypeResolverProvider getTypeResolverProvider() {
        return this.typeResolverProvider;
    }
}

