/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.collections;

import java.lang.reflect.Array;
import java.util.StringJoiner;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.ObjIntConsumer;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import java.util.stream.Stream;
import org.evrete.api.BufferedInsert;
import org.evrete.api.ReIterable;
import org.evrete.api.ReIterator;
import org.evrete.collections.UnsignedIntArray;
import org.evrete.util.CollectionUtils;

public abstract class AbstractHashData<E>
extends UnsignedIntArray
implements ReIterable<E>,
BufferedInsert {
    protected static final BiPredicate<Object, Object> IDENTITY_EQUALS = (o1, o2) -> o1 == o2;
    static final ToIntFunction<Object> DEFAULT_HASH = Object::hashCode;
    static final ToIntFunction<Object> IDENTITY_HASH = System::identityHashCode;
    static final BiPredicate<Object, Object> DEFAULT_EQUALS = Object::equals;
    private static final int DEFAULT_INITIAL_CAPACITY = 4;
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private static final int MINIMUM_CAPACITY = 2;
    Object[] data;
    boolean[] deletedIndices;
    int size = 0;
    int deletes = 0;

    protected AbstractHashData(int initialCapacity) {
        super(initialCapacity);
        int capacity = AbstractHashData.tableSizeFor(initialCapacity);
        this.data = new Object[capacity];
        this.deletedIndices = new boolean[capacity];
    }

    protected AbstractHashData() {
        this(4);
    }

    private static int findBinIndexFor(Object key, int hash, Object[] destination, BiPredicate<Object, Object> eqTest) {
        Object found;
        int mask = destination.length - 1;
        int addr = hash & mask;
        while ((found = destination[addr]) != null) {
            if (eqTest.test(key, found)) {
                return addr;
            }
            addr = addr + 1 & mask;
        }
        return addr;
    }

    private static int findEmptyBinIndex(int hash, Object[] destination) {
        int mask = destination.length - 1;
        int addr = hash & mask;
        while (destination[addr] != null) {
            addr = addr + 1 & mask;
        }
        return addr;
    }

    private static <K, E> int findBinIndex(K key, int hash, Object[] destination, BiPredicate<E, K> eqTest) {
        Object found;
        int mask = destination.length - 1;
        int addr = hash & mask;
        while ((found = destination[addr]) != null) {
            if (eqTest.test(found, key)) {
                return addr;
            }
            addr = addr + 1 & mask;
        }
        return addr;
    }

    private static int findBinIndexFor(int hash, Object[] destination, Predicate<Object> eqTest) {
        Object found;
        int mask = destination.length - 1;
        int addr = hash & mask;
        while ((found = destination[addr]) != null) {
            if (eqTest.test(found)) {
                return addr;
            }
            addr = addr + 1 & mask;
        }
        return addr;
    }

    private static int tableSizeFor(int capacity) {
        int cap = Math.max(capacity, 2);
        int n = -1 >>> Integer.numberOfLeadingZeros(cap - 1);
        return n >= 0x40000000 ? 0x40000000 : n + 1;
    }

    public E get(int addr) {
        return (E)(this.deletedIndices[addr] ? null : this.data[addr]);
    }

    private int findBinIndexFor(Object key, int hash, BiPredicate<Object, Object> eqTest) {
        return AbstractHashData.findBinIndexFor(key, hash, this.data, eqTest);
    }

    public <K> int findBinIndex(K key, int hash, BiPredicate<? super E, K> eqTest) {
        return AbstractHashData.findBinIndex(key, hash, this.data, eqTest);
    }

    int findBinIndexFor(int hash, Predicate<Object> eqTest) {
        return AbstractHashData.findBinIndexFor(hash, this.data, eqTest);
    }

    public final boolean add(E element) {
        this.resize();
        int hash = this.getHashFunction().applyAsInt(element);
        int addr = this.findBinIndexFor(element, hash, this.getEqualsPredicate());
        return this.saveDirect(element, addr);
    }

    public final void addNoResize(E element) {
        int hash = this.getHashFunction().applyAsInt(element);
        int addr = this.findBinIndexFor(element, hash, this.getEqualsPredicate());
        this.saveDirect(element, addr);
    }

    public final <Z extends AbstractHashData<E>> void bulkAdd(Z other) {
        this.resize(this.size + other.size);
        ToIntFunction<Object> hashFunc = this.getHashFunction();
        BiPredicate<Object, Object> eqPredicate = this.getEqualsPredicate();
        for (int i = 0; i < other.currentInsertIndex; ++i) {
            int idx = other.getAt(i);
            E o = other.get(idx);
            if (o == null) continue;
            int hash = hashFunc.applyAsInt(o);
            int addr = this.findBinIndexFor(o, hash, eqPredicate);
            this.saveDirect(o, addr);
        }
    }

    @Override
    public final void ensureExtraCapacity(int insertCount) {
        this.resize(this.size + insertCount);
    }

    public final boolean saveDirect(E element, int addr) {
        if (this.data[addr] == null) {
            this.data[addr] = element;
            this.addNew(addr);
            ++this.size;
            return true;
        }
        if (this.deletedIndices[addr]) {
            this.deletedIndices[addr] = false;
            --this.deletes;
            ++this.size;
            this.data[addr] = element;
            return true;
        }
        return false;
    }

    protected abstract ToIntFunction<Object> getHashFunction();

    protected abstract BiPredicate<Object, Object> getEqualsPredicate();

    @Override
    final int dataSize() {
        return this.data.length;
    }

    public final int size() {
        return this.size;
    }

    final boolean deleteEntries(Predicate<E> predicate) {
        int initialDeletes = this.deletes;
        this.forEachDataEntry((E e, int i) -> {
            if (predicate.test(e)) {
                this.markDeleted(i);
            }
        });
        if (initialDeletes == this.deletes) {
            return false;
        }
        this.resize();
        return true;
    }

    public void forEachDataEntry(Consumer<E> consumer) {
        for (int i = 0; i < this.currentInsertIndex; ++i) {
            E obj = this.get(this.getAt(i));
            if (obj == null) continue;
            consumer.accept(obj);
        }
    }

    private void forEachDataEntry(ObjIntConsumer<E> consumer) {
        for (int i = 0; i < this.currentInsertIndex; ++i) {
            int idx = this.getAt(i);
            E obj = this.get(idx);
            if (obj == null) continue;
            consumer.accept(obj, idx);
        }
    }

    protected void markDeleted(int addr) {
        this.deletedIndices[addr] = true;
        ++this.deletes;
        --this.size;
    }

    @Override
    public String toString() {
        StringJoiner joiner = new StringJoiner(", ", "[", "]");
        this.forEachDataEntry((E k) -> joiner.add(k.toString()));
        return joiner.toString();
    }

    @Override
    public final void clear() {
        super.clear();
        CollectionUtils.systemFill(this.data, null);
        CollectionUtils.systemFill(this.deletedIndices, false);
        this.size = 0;
        this.deletes = 0;
    }

    boolean containsEntry(E e) {
        int addr = this.findBinIndexFor(e, this.getHashFunction().applyAsInt(e), this.getEqualsPredicate());
        return this.data[addr] != null && !this.deletedIndices[addr];
    }

    boolean removeEntry(Object e) {
        int addr = this.findBinIndexFor(e, this.getHashFunction().applyAsInt(e), this.getEqualsPredicate());
        return this.removeEntry(addr);
    }

    private boolean removeEntry(int addr) {
        if (this.data[addr] == null) {
            return false;
        }
        if (this.deletedIndices[addr]) {
            return false;
        }
        this.removeNonEmpty(addr);
        return true;
    }

    private void removeNonEmpty(int addr) {
        this.markDeleted(addr);
        this.resize();
    }

    @Override
    public ReIterator<E> iterator() {
        return new It();
    }

    public Stream<E> stream() {
        return this.intStream().filter(i -> !this.deletedIndices[i]).mapToObj(value -> this.data[value]);
    }

    public void resize() {
        assert (this.currentInsertIndex() == this.size + this.deletes) : "indices: " + this.currentInsertIndex() + " size: " + this.size + ", deletes: " + this.deletes;
        this.resize(this.size);
    }

    public void resize(int targetSize) {
        boolean shrink;
        boolean expand = 2 * (targetSize + this.deletes) >= this.data.length;
        boolean bl = shrink = this.deletes > 0 && targetSize < this.deletes;
        if (expand || shrink) {
            int newSize = AbstractHashData.tableSizeFor(Math.max(2, targetSize * 2 + 1));
            if (newSize > 0x40000000) {
                throw new OutOfMemoryError();
            }
            Object[] newData = (Object[])Array.newInstance(this.data.getClass().getComponentType(), newSize);
            UnsignedIntArray newIndices = new UnsignedIntArray(newSize);
            if (targetSize > 0) {
                ToIntFunction<Object> hashFunction = this.getHashFunction();
                this.forEachDataEntry((E e) -> {
                    int addr = AbstractHashData.findEmptyBinIndex(hashFunction.applyAsInt(e), newData);
                    newData[addr] = e;
                    newIndices.addNew(addr);
                });
            }
            this.data = newData;
            this.copyFrom(newIndices);
            this.deletes = 0;
            this.deletedIndices = new boolean[newSize];
        }
    }

    void assertStructure() {
        int indices = this.currentInsertIndex();
        int deletes = this.deletes;
        assert (indices == this.size + deletes) : "indices: " + indices + " size: " + this.size + ", deletes: " + deletes;
    }

    private class It
    extends AbstractIterator<E> {
        private It() {
        }

        @Override
        public E next() {
            return this.nextObject();
        }
    }

    private abstract class AbstractIterator<T>
    implements ReIterator<T> {
        private int pos;
        private Object next;

        AbstractIterator() {
            this.reset();
        }

        final void findNext() {
            this.next = null;
            while (this.next == null && this.pos < AbstractHashData.this.currentInsertIndex) {
                int idx;
                this.next = AbstractHashData.this.deletedIndices[idx = AbstractHashData.this.getAt(this.pos++)] ? null : AbstractHashData.this.data[idx];
            }
        }

        @Override
        public final long reset() {
            this.pos = 0;
            this.findNext();
            return AbstractHashData.this.size;
        }

        public String toString() {
            return AbstractHashData.this.toString();
        }

        Object nextObject() {
            Object ret = this.next;
            this.findNext();
            return ret;
        }

        @Override
        public final boolean hasNext() {
            return this.next != null;
        }
    }
}

