/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.collections;

import org.evrete.api.EachRunnable;
import org.evrete.api.ReIterable;
import org.evrete.api.ReIterator;

public class NestedReIterator<T>
implements EachRunnable {
    private final ReIterator<T>[] iterators;
    private final T[] state;
    private final int lastIndex;

    public NestedReIterator(T[] state) {
        this.iterators = new ReIterator[state.length];
        this.state = state;
        this.lastIndex = state.length - 1;
    }

    public <I extends ReIterable<T>> void setIterables(I[] data) {
        for (int i = 0; i < data.length; ++i) {
            this.set(i, data[i].iterator());
        }
    }

    public long reset() {
        long l = 1L;
        for (ReIterator<T> it : this.iterators) {
            l *= it.reset();
        }
        return l;
    }

    public <I extends ReIterator<T>> void setIterators(I[] data) {
        for (int i = 0; i < data.length; ++i) {
            this.set(i, (ReIterator<T>)data[i]);
        }
    }

    private void set(int index, ReIterator<T> iterator) {
        this.iterators[index] = iterator;
    }

    @Override
    public void runForEach(Runnable r) {
        this.runForEach(0, r);
    }

    private void runForEach(int index, Runnable r) {
        ReIterator<T> it = this.iterators[index];
        if (it.reset() == 0L) {
            return;
        }
        if (index == this.lastIndex) {
            while (it.hasNext()) {
                this.state[index] = it.next();
                r.run();
            }
        } else {
            while (it.hasNext()) {
                this.state[index] = it.next();
                this.runForEach(index + 1, r);
            }
        }
    }
}

