/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import org.evrete.Configuration;
import org.evrete.KnowledgeService;
import org.evrete.api.ActivationManager;
import org.evrete.api.ActiveField;
import org.evrete.api.EvaluationListener;
import org.evrete.api.Evaluator;
import org.evrete.api.ExpressionResolver;
import org.evrete.api.FieldsKey;
import org.evrete.api.KeysStore;
import org.evrete.api.MemoryCollections;
import org.evrete.api.Named;
import org.evrete.api.NamedType;
import org.evrete.api.RhsContext;
import org.evrete.api.Rule;
import org.evrete.api.RuleBuilder;
import org.evrete.api.RuntimeContext;
import org.evrete.api.SharedBetaFactStorage;
import org.evrete.api.SharedPlainFactStorage;
import org.evrete.api.Type;
import org.evrete.api.TypeField;
import org.evrete.api.TypeResolver;
import org.evrete.api.TypeResolverWrapper;
import org.evrete.api.spi.LiteralRhsCompiler;
import org.evrete.runtime.ActiveFields;
import org.evrete.runtime.FactType;
import org.evrete.runtime.RuleDescriptor;
import org.evrete.runtime.RuntimeListeners;
import org.evrete.runtime.async.Completer;
import org.evrete.runtime.async.ForkJoinExecutor;
import org.evrete.runtime.builder.RuleBuilderImpl;
import org.evrete.runtime.evaluation.AlphaBucketMeta;
import org.evrete.runtime.evaluation.AlphaConditions;
import org.evrete.runtime.evaluation.AlphaDelta;
import org.evrete.util.LazyInstance;

public abstract class AbstractRuntime<C extends RuntimeContext<C>>
implements RuntimeContext<C> {
    private final List<RuleBuilder<C>> ruleBuilders = new ArrayList<RuleBuilder<C>>();
    private final List<RuleDescriptor> ruleDescriptors;
    private final AtomicInteger ruleCounter;
    private final RuntimeListeners listeners;
    private final Set<String> imports;
    private final AlphaConditions alphaConditions;
    private final KnowledgeService service;
    private final ActiveFields activeFields;
    private final Queue<Completer> tasksQueue = new LinkedList<Completer>();
    private final LazyInstance<MemoryCollections> collectionsService = new LazyInstance<MemoryCollections>(this::newCollectionsService);
    private final LazyInstance<ExpressionResolver> expressionResolver = new LazyInstance<ExpressionResolver>(this::newExpressionResolver);
    private final LazyInstance<TypeResolver> typeResolver = new LazyInstance<TypeResolver>(this::newTypeResolver);
    private final LazyInstance<LiteralRhsCompiler> rhsCompiler = new LazyInstance<LiteralRhsCompiler>(this::newLiteralLhsProvider);
    private final Map<String, Object> properties;
    private final AbstractRuntime<?> parent;
    private ClassLoader classLoader;
    private Comparator<Rule> ruleComparator = SALIENCE_COMPARATOR;
    private Class<? extends ActivationManager> activationManagerFactory;

    AbstractRuntime(KnowledgeService service) {
        this.parent = null;
        this.ruleCounter = new AtomicInteger();
        this.alphaConditions = new AlphaConditions();
        this.ruleDescriptors = new ArrayList<RuleDescriptor>();
        this.listeners = new RuntimeListeners();
        this.service = service;
        this.activeFields = new ActiveFields();
        this.activationManagerFactory = UnconditionalActivationManager.class;
        this.classLoader = service.getClassLoader();
        this.imports = new HashSet<String>();
        this.properties = new ConcurrentHashMap<String, Object>();
    }

    protected AbstractRuntime(AbstractRuntime<?> parent) {
        this.parent = parent;
        this.ruleCounter = new AtomicInteger(parent.ruleCounter.intValue());
        this.alphaConditions = parent.alphaConditions.copyOf();
        this.ruleDescriptors = new ArrayList<RuleDescriptor>(parent.ruleDescriptors);
        this.service = parent.service;
        this.listeners = parent.listeners.copyOf();
        this.activeFields = parent.activeFields.copyOf();
        this.ruleComparator = parent.ruleComparator;
        this.activationManagerFactory = parent.activationManagerFactory;
        this.classLoader = parent.classLoader;
        this.imports = new HashSet<String>(parent.imports);
        this.properties = new ConcurrentHashMap<String, Object>(parent.properties);
    }

    protected abstract TypeResolver newTypeResolver();

    protected abstract void onNewActiveField(ActiveField var1);

    protected abstract void onNewAlphaBucket(AlphaDelta var1);

    @Override
    public RuntimeContext<?> addImport(String imp) {
        this.imports.add(imp);
        return this;
    }

    @Override
    public <T> void set(String property, T value) {
        this.properties.put(property, value);
    }

    @Override
    public <T> T get(String property) {
        return (T)this.properties.get(property);
    }

    @Override
    public Collection<String> getPropertyNames() {
        return this.properties.keySet();
    }

    @Override
    public Set<String> getImports() {
        return this.imports;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    protected KnowledgeService getService() {
        return this.service;
    }

    @Override
    public AbstractRuntime<?> getParentContext() {
        return this.parent;
    }

    @Override
    public final void wrapTypeResolver(TypeResolverWrapper wrapper) {
        this.typeResolver.set(wrapper);
    }

    @Override
    public final TypeResolver getTypeResolver() {
        return this.typeResolver.get();
    }

    @Override
    public Class<? extends ActivationManager> getActivationManagerFactory() {
        return this.activationManagerFactory;
    }

    @Override
    public <A extends ActivationManager> void setActivationManagerFactory(Class<A> managerClass) {
        this.activationManagerFactory = managerClass;
    }

    @Override
    public final void setActivationManagerFactory(String managerClass) {
        try {
            Class<?> factory = Class.forName(managerClass, true, this.classLoader);
            this.setActivationManagerFactory(factory);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(managerClass);
        }
    }

    protected ActivationManager newActivationManager() {
        try {
            return this.activationManagerFactory.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable e) {
            throw new RuntimeException("Unable to create activation manager. Probably the provided factory class has no public and zero-argument constructor.", e);
        }
    }

    protected void queueTask(Completer task) {
        this.tasksQueue.add(task);
    }

    protected void processAllTasks() {
        Completer task;
        ForkJoinExecutor executor = this.getExecutor();
        while ((task = this.tasksQueue.poll()) != null) {
            executor.invoke(task);
        }
    }

    @Override
    public Comparator<Rule> getRuleComparator() {
        return this.ruleComparator;
    }

    @Override
    public void setRuleComparator(Comparator<Rule> ruleComparator) {
        this.ruleComparator = ruleComparator;
    }

    protected ForkJoinExecutor getExecutor() {
        return this.service.getExecutor();
    }

    public LazyInstance<LiteralRhsCompiler> getRhsCompiler() {
        return this.rhsCompiler;
    }

    public Evaluator compile(String expression, Function<String, NamedType> resolver) {
        return this.getExpressionResolver().buildExpression(expression, resolver);
    }

    public ActiveField getCreateActiveField(TypeField field) {
        return this.activeFields.getCreate(field, this::onNewActiveField);
    }

    public ActiveField[] getActiveFields(Type<?> type) {
        return this.activeFields.getActiveFields(type);
    }

    AlphaBucketMeta getCreateAlphaMask(FieldsKey fields, boolean beta, Set<Evaluator> typePredicates) {
        return this.alphaConditions.register(this, fields, beta, typePredicates, this::onNewAlphaBucket);
    }

    @Override
    public RuntimeListeners getListeners() {
        return this.listeners;
    }

    public List<RuleDescriptor> getRuleDescriptors() {
        return this.ruleDescriptors;
    }

    public AlphaConditions getAlphaConditions() {
        return this.alphaConditions;
    }

    @Override
    public RuleBuilder<C> newRule() {
        return this.newRule(RuleBuilderImpl.class.getName() + "#" + this.ruleCounter.get());
    }

    @Override
    public RuleBuilderImpl<C> newRule(String name) {
        RuleBuilderImpl rb = new RuleBuilderImpl(this, name, -1 * this.ruleCounter.getAndIncrement());
        this.ruleBuilders.add(rb);
        return rb;
    }

    @Override
    public boolean ruleExists(String name) {
        Objects.requireNonNull(name);
        return Named.find(this.ruleDescriptors, name) != null;
    }

    @Override
    public RuleDescriptor getRuleDescriptor(String name) {
        return Named.find(this.ruleDescriptors, name);
    }

    @Override
    public Configuration getConfiguration() {
        return this.service.getConfiguration();
    }

    private MemoryCollections newCollectionsService() {
        return this.service.getCollectionsServiceProvider().instance(this);
    }

    private ExpressionResolver newExpressionResolver() {
        return this.service.getExpressionResolverProvider().instance(this);
    }

    private LiteralRhsCompiler newLiteralLhsProvider() {
        return this.service.getLiteralRhsProvider();
    }

    public <Z> KeysStore newKeysStore(Z[][] grouping) {
        return this.collectionsService.get().newKeyStore(grouping);
    }

    public KeysStore newKeysStore(int[] factTypeCounts) {
        return this.collectionsService.get().newKeyStore(factTypeCounts);
    }

    public SharedPlainFactStorage newSharedPlainStorage() {
        return this.collectionsService.get().newPlainStorage();
    }

    public SharedBetaFactStorage newSharedKeyStorage(FieldsKey fieldsKey) {
        return this.collectionsService.get().newBetaStorage(fieldsKey);
    }

    @Override
    public final synchronized RuleDescriptor compileRule(RuleBuilder<?> ruleBuilder) {
        if (!this.ruleBuilders.remove(ruleBuilder)) {
            throw new IllegalArgumentException("No such rule builder");
        }
        if (this.ruleExists(ruleBuilder.getName())) {
            throw new IllegalArgumentException("Rule '" + ruleBuilder.getName() + "' already exists");
        }
        RuleBuilderImpl rb = (RuleBuilderImpl)ruleBuilder;
        RuleDescriptor rd = RuleDescriptor.factory(this, rb);
        this.ruleDescriptors.add(rd);
        return rd;
    }

    Consumer<RhsContext> compile(String literalRhs, Collection<FactType> factTypes, Collection<String> imports) {
        return this.getRhsCompiler().get().compileRhs(this, literalRhs, factTypes, imports);
    }

    public ExpressionResolver getExpressionResolver() {
        return this.expressionResolver.get();
    }

    @Override
    public void addConditionTestListener(EvaluationListener listener) {
        this.listeners.addConditionTestListener(listener);
    }

    static class UnconditionalActivationManager
    implements ActivationManager {
        UnconditionalActivationManager() {
        }
    }
}

