/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.evrete.api.RuntimeFact;
import org.evrete.api.ValueRow;
import org.evrete.runtime.AbstractLhsDescriptor;
import org.evrete.runtime.ActivationSubject;
import org.evrete.runtime.ConditionNodeDescriptor;
import org.evrete.runtime.LhsDescriptor;
import org.evrete.runtime.RhsFactGroup;
import org.evrete.runtime.RhsFactGroupAlpha;
import org.evrete.runtime.RhsFactGroupBeta;
import org.evrete.runtime.RhsFactGroupDescriptor;
import org.evrete.runtime.RuntimeFactTypeKeyed;
import org.evrete.runtime.RuntimeRuleImpl;
import org.evrete.runtime.memory.BetaEndNode;
import org.evrete.util.CollectionUtils;

public abstract class AbstractRuntimeLhs
implements ActivationSubject {
    final RuntimeFact[][] factState;
    private final Collection<BetaEndNode> endNodes = new ArrayList<BetaEndNode>();
    private final AbstractLhsDescriptor descriptor;
    private final AbstractRuntimeLhs parent;
    private final Map<ConditionNodeDescriptor, BetaEndNode> betaEndNodeMap = new HashMap<ConditionNodeDescriptor, BetaEndNode>();
    private final RhsFactGroup[] rhsFactGroups;
    private final RhsFactGroupAlpha alphaFactGroup;
    private final RhsFactGroupBeta[] betaFactGroups;
    private final ValueRow[][] keyState;

    AbstractRuntimeLhs(RuntimeRuleImpl rule, AbstractRuntimeLhs parent, AbstractLhsDescriptor descriptor) {
        this.descriptor = descriptor;
        this.parent = parent;
        RhsFactGroupDescriptor[] allFactGroups = descriptor.getAllFactGroups();
        this.rhsFactGroups = new RhsFactGroup[allFactGroups.length];
        this.keyState = new ValueRow[allFactGroups.length][];
        this.factState = new RuntimeFact[allFactGroups.length][];
        RhsFactGroupAlpha alpha = null;
        for (RhsFactGroupDescriptor groupDescriptor : allFactGroups) {
            RhsFactGroup factGroup;
            int groupIndex = groupDescriptor.getFactGroupIndex();
            this.factState[groupIndex] = new RuntimeFact[groupDescriptor.getTypes().length];
            if (groupDescriptor.isLooseGroup()) {
                factGroup = alpha = new RhsFactGroupAlpha(rule, groupDescriptor, this.factState);
            } else {
                ConditionNodeDescriptor finalNode = groupDescriptor.getFinalNode();
                if (finalNode != null) {
                    BetaEndNode endNode = new BetaEndNode(rule, finalNode);
                    this.endNodes.add(endNode);
                    this.betaEndNodeMap.put(finalNode, endNode);
                    factGroup = new RhsFactGroupBeta(groupDescriptor, endNode, this.keyState, this.factState);
                } else {
                    RuntimeFactTypeKeyed singleType = (RuntimeFactTypeKeyed)rule.resolve(groupDescriptor.getTypes()[0]);
                    factGroup = new RhsFactGroupBeta(groupDescriptor, singleType, this.keyState, this.factState);
                }
            }
            this.rhsFactGroups[groupIndex] = factGroup;
        }
        this.betaFactGroups = CollectionUtils.filter(RhsFactGroupBeta.class, this.rhsFactGroups, group -> !group.isAlpha());
        this.alphaFactGroup = alpha;
    }

    AbstractRuntimeLhs(RuntimeRuleImpl rule, LhsDescriptor descriptor) {
        this(rule, null, descriptor);
    }

    @Override
    public boolean isInActiveState() {
        return this.readState(this.rhsFactGroups);
    }

    @Override
    public void resetState() {
        this.resetState(this.rhsFactGroups);
    }

    public RhsFactGroupAlpha getAlphaFactGroup() {
        return this.alphaFactGroup;
    }

    public RhsFactGroupBeta[] getBetaFactGroups() {
        return this.betaFactGroups;
    }

    public ValueRow[][] getKeyState() {
        return this.keyState;
    }

    public <T extends RhsFactGroup> T getGroup(RhsFactGroupDescriptor descriptor) {
        return (T)this.rhsFactGroups[descriptor.getFactGroupIndex()];
    }

    public AbstractLhsDescriptor getDescriptor() {
        return this.descriptor;
    }

    public final BetaEndNode resolve(ConditionNodeDescriptor descriptor) {
        AbstractRuntimeLhs current = this;
        while (current != null) {
            BetaEndNode node = this.betaEndNodeMap.get(descriptor);
            if (node != null) {
                return node;
            }
            current = current.parent;
        }
        throw new IllegalArgumentException("Node not found or the argument is not an end-node");
    }

    Collection<BetaEndNode> getEndNodes() {
        return this.endNodes;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{descriptor=" + this.descriptor + '}';
    }
}

