/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import org.evrete.api.KeyMode;
import org.evrete.api.KeyReIterators;
import org.evrete.api.ReIterator;
import org.evrete.api.RuntimeFact;
import org.evrete.api.ValueRow;
import org.evrete.collections.NestedReIterator;
import org.evrete.runtime.RhsFactGroup;
import org.evrete.runtime.RhsFactGroupDescriptor;
import org.evrete.runtime.RuntimeFactTypeKeyed;
import org.evrete.runtime.ScanMode;
import org.evrete.runtime.memory.BetaEndNode;

public class RhsFactGroupBeta
implements RhsFactGroup,
KeyReIterators<ValueRow[]> {
    private final RuntimeFactTypeKeyed[] types;
    private final KeyReIterators<ValueRow[]> keyIterators;
    private final ValueRow[][] keyState;
    private final int groupIndex;
    private final NestedReIterator<RuntimeFact> nestedFactIterator;

    private RhsFactGroupBeta(RhsFactGroupDescriptor descriptor, RuntimeFactTypeKeyed[] types, KeyReIterators<ValueRow[]> keyIterators, ValueRow[][] keyState, RuntimeFact[][] factState) {
        this.types = types;
        this.keyIterators = keyIterators;
        this.keyState = keyState;
        this.groupIndex = descriptor.getFactGroupIndex();
        this.nestedFactIterator = new NestedReIterator<RuntimeFact>(factState[this.groupIndex]);
    }

    public RhsFactGroupBeta(RhsFactGroupDescriptor descriptor, BetaEndNode endNode, ValueRow[][] keyState, RuntimeFact[][] factState) {
        this(descriptor, endNode.getEntryNodes(), endNode, keyState, factState);
    }

    public RhsFactGroupBeta(RhsFactGroupDescriptor descriptor, RuntimeFactTypeKeyed singleType, ValueRow[][] keyState, RuntimeFact[][] factState) {
        this(descriptor, new RuntimeFactTypeKeyed[]{singleType}, singleType.getMappedKeyIterators(), keyState, factState);
    }

    static void runKeys(ScanMode mode, RhsFactGroupBeta[] groups, Runnable r) {
        switch (mode) {
            case DELTA: {
                RhsFactGroupBeta.runDelta(0, groups.length - 1, false, groups, r);
                return;
            }
            case KNOWN: {
                RhsFactGroupBeta.runKnown(0, groups.length - 1, groups, r);
                return;
            }
            case FULL: {
                RhsFactGroupBeta.runFull(0, groups.length - 1, groups, r);
                return;
            }
        }
        throw new UnsupportedOperationException();
    }

    private static void runDelta(int index, int lastIndex, boolean hasDelta, RhsFactGroupBeta[] groups, Runnable r) {
        RhsFactGroupBeta group = groups[index];
        Set<Map.Entry<KeyMode, ReIterator<ValueRow[]>>> entries = group.keyIterators().entrySet();
        if (index == lastIndex) {
            for (Map.Entry<KeyMode, ReIterator<ValueRow[]>> entry : entries) {
                KeyMode mode = entry.getKey();
                ReIterator<ValueRow[]> iterator = entry.getValue();
                if (!mode.isDeltaMode() && !hasDelta || iterator.reset() <= 0L) continue;
                while (iterator.hasNext()) {
                    if (!group.setKey((ValueRow[])iterator.next())) continue;
                    r.run();
                }
            }
        } else {
            for (Map.Entry<KeyMode, ReIterator<ValueRow[]>> entry : entries) {
                KeyMode mode = entry.getKey();
                ReIterator<ValueRow[]> iterator = entry.getValue();
                if (iterator.reset() <= 0L) continue;
                while (iterator.hasNext()) {
                    if (!group.setKey((ValueRow[])iterator.next())) continue;
                    RhsFactGroupBeta.runDelta(index + 1, lastIndex, mode.isDeltaMode(), groups, r);
                }
            }
        }
    }

    private static void runFull(int index, int lastIndex, RhsFactGroupBeta[] groups, Runnable r) {
        RhsFactGroupBeta group = groups[index];
        Set<Map.Entry<KeyMode, ReIterator<ValueRow[]>>> entries = group.keyIterators().entrySet();
        if (index == lastIndex) {
            for (Map.Entry<KeyMode, ReIterator<ValueRow[]>> entry : entries) {
                ReIterator<ValueRow[]> iterator = entry.getValue();
                if (iterator.reset() <= 0L) continue;
                while (iterator.hasNext()) {
                    if (!group.setKey((ValueRow[])iterator.next())) continue;
                    r.run();
                }
            }
        } else {
            for (Map.Entry<KeyMode, ReIterator<ValueRow[]>> entry : entries) {
                ReIterator<ValueRow[]> iterator = entry.getValue();
                if (iterator.reset() <= 0L) continue;
                while (iterator.hasNext()) {
                    if (!group.setKey((ValueRow[])iterator.next())) continue;
                    RhsFactGroupBeta.runFull(index + 1, lastIndex, groups, r);
                }
            }
        }
    }

    private static void runKnown(int index, int lastIndex, RhsFactGroupBeta[] groups, Runnable r) {
        RhsFactGroupBeta group = groups[index];
        Set<Map.Entry<KeyMode, ReIterator<ValueRow[]>>> entries = group.keyIterators().entrySet();
        if (index == lastIndex) {
            for (Map.Entry<KeyMode, ReIterator<ValueRow[]>> entry : entries) {
                KeyMode mode = entry.getKey();
                ReIterator<ValueRow[]> iterator = entry.getValue();
                if (mode.isDeltaMode() || iterator.reset() <= 0L) continue;
                while (iterator.hasNext()) {
                    if (!group.setKey((ValueRow[])iterator.next())) continue;
                    r.run();
                }
            }
        } else {
            for (Map.Entry<KeyMode, ReIterator<ValueRow[]>> entry : entries) {
                KeyMode mode = entry.getKey();
                ReIterator<ValueRow[]> iterator = entry.getValue();
                if (iterator.reset() <= 0L || mode.isDeltaMode()) continue;
                while (iterator.hasNext()) {
                    if (!group.setKey((ValueRow[])iterator.next())) continue;
                    RhsFactGroupBeta.runKnown(index + 1, lastIndex, groups, r);
                }
            }
        }
    }

    static void runCurrentFacts(RhsFactGroupBeta[] groups, Runnable r) {
        RhsFactGroupBeta.runCurrentFacts(0, groups.length - 1, groups, r);
    }

    private static void runCurrentFacts(int index, int lastIndex, RhsFactGroupBeta[] groups, Runnable r) {
        RhsFactGroupBeta group = groups[index];
        if (index == lastIndex) {
            group.runForEachFact(r);
        } else {
            int nextIndex = index + 1;
            Runnable nested = () -> RhsFactGroupBeta.runCurrentFacts(nextIndex, lastIndex, groups, r);
            group.runForEachFact(nested);
        }
    }

    private boolean setKey(ValueRow[] key) {
        this.keyState[this.groupIndex] = key;
        this.nestedFactIterator.setIterables(key);
        return true;
    }

    private void runForEachFact(Runnable r) {
        this.nestedFactIterator.runForEach(r);
    }

    @Override
    public EnumMap<KeyMode, ReIterator<ValueRow[]>> keyIterators() {
        return this.keyIterators.keyIterators();
    }

    @Override
    public boolean isAlpha() {
        return false;
    }

    @Override
    public int getIndex() {
        return this.groupIndex;
    }

    public RuntimeFactTypeKeyed[] getTypes() {
        return this.types;
    }

    @Override
    public boolean isInActiveState() {
        return this.readState(this.types);
    }

    @Override
    public void resetState() {
        this.resetState(this.types);
    }
}

