/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.util.EnumMap;
import java.util.function.BooleanSupplier;
import java.util.function.IntFunction;
import org.evrete.api.IntToValue;
import org.evrete.api.IntToValueRow;
import org.evrete.api.KeyMode;
import org.evrete.api.KeyReIterators;
import org.evrete.api.KeysStore;
import org.evrete.api.ReIterator;
import org.evrete.api.ValueRow;
import org.evrete.runtime.AbstractRuntimeLhs;
import org.evrete.runtime.AggregateEvaluator;
import org.evrete.runtime.AggregateLhsDescriptor;
import org.evrete.runtime.FactType;
import org.evrete.runtime.FactTypeField;
import org.evrete.runtime.RhsFactGroupBeta;
import org.evrete.runtime.RhsFactGroupDescriptor;
import org.evrete.runtime.RuntimeAggregateLhs;
import org.evrete.runtime.RuntimeRuleImpl;
import org.evrete.runtime.evaluation.EvaluatorInternal;

public class RuntimeAggregateLhsJoined
extends RuntimeAggregateLhs {
    private final ValueRow[][] state;
    private final SourceIterator[] iterators;
    private final EvaluatorInternal[] evaluators;
    private final IntToValue[] evaluatorValues;
    private final KeysStore successData;
    private final IntFunction<IntToValueRow> saveMapper;
    private final BooleanSupplier aggregateKeyPredicate;
    private final int[][][] saveMapping;
    private final AggregateLhsDescriptor descriptor;

    public RuntimeAggregateLhsJoined(RuntimeRuleImpl rule, AbstractRuntimeLhs parent, AggregateLhsDescriptor descriptor) {
        super(rule, parent, descriptor);
        int allFactTypes = rule.getAllFactTypes().length;
        this.descriptor = descriptor;
        AggregateEvaluator aggregateEvaluator = descriptor.getJoinCondition();
        this.evaluators = descriptor.getJoinCondition().getEvaluators();
        this.evaluatorValues = new IntToValue[this.evaluators.length];
        AbstractRuntimeLhs[] allLhs = new AbstractRuntimeLhs[]{parent, this};
        this.saveMapping = new int[allLhs.length][][];
        AggregateEvaluator.LevelData[] levelData = aggregateEvaluator.getLevelData();
        int[] groupingSizes = new int[levelData.length];
        int totalGroups = 0;
        for (int level2 = 0; level2 < levelData.length; ++level2) {
            AggregateEvaluator.LevelData data = levelData[level2];
            FactType[] types = data.getFactTypeSequence();
            this.saveMapping[level2] = new int[types.length][];
            groupingSizes[level2] = types.length;
            totalGroups += data.getKeyGroupSequence().length;
        }
        this.iterators = new SourceIterator[totalGroups];
        this.state = new ValueRow[this.iterators.length][];
        int iteratorIndex = 0;
        for (int level3 = 0; level3 < levelData.length; ++level3) {
            RhsFactGroupDescriptor[] groupDescriptors;
            SourceIterator[] data = levelData[level3];
            int inLevelIndex = 0;
            for (RhsFactGroupDescriptor d : groupDescriptors = data.getKeyGroupSequence()) {
                FactType[] types;
                for (FactType t : types = d.getTypes()) {
                    this.saveMapping[level3][inLevelIndex] = new int[]{iteratorIndex, t.getInGroupIndex()};
                    ++inLevelIndex;
                }
                AbstractRuntimeLhs lhs = allLhs[level3];
                RhsFactGroupBeta beta = (RhsFactGroupBeta)lhs.getGroup(d);
                this.iterators[iteratorIndex] = new SourceIterator(iteratorIndex, d, beta);
                ++iteratorIndex;
            }
        }
        this.successData = rule.getMemory().newKeysStore(groupingSizes);
        this.saveMapper = level -> typeIndex -> {
            int[] addr = this.saveMapping[level][typeIndex];
            return this.state[addr[0]][addr[1]];
        };
        int[][] conditionMapping = new int[allFactTypes][];
        for (SourceIterator iterator : this.iterators) {
            int t = 0;
            while (t < iterator.types.length) {
                FactType type = iterator.types[t];
                int typeId = type.getInRuleIndex();
                assert (conditionMapping[typeId] == null);
                conditionMapping[typeId] = new int[]{iterator.index, t++};
            }
        }
        for (int i = 0; i < this.evaluators.length; ++i) {
            this.evaluatorValues[i] = new IntToValueImpl(this.evaluators[i], this.state, conditionMapping);
        }
        this.aggregateKeyPredicate = descriptor.getAggregateEvaluatorFactory().joinedGroupEvaluator(parent, this);
    }

    public BooleanSupplier getAggregateKeyPredicate() {
        return this.aggregateKeyPredicate;
    }

    public KeysStore getSuccessData() {
        return this.successData;
    }

    @Override
    public AggregateLhsDescriptor getDescriptor() {
        return this.descriptor;
    }

    public void evaluate(boolean deltaOnly) {
        this.evaluate(0, false, deltaOnly);
        System.out.println("@@@@@ " + this.successData);
    }

    private void evaluate(int index, boolean hasDelta, boolean deltaOnly) {
        block8: {
            SourceIterator iterator;
            block7: {
                iterator = this.iterators[index];
                if (index != this.iterators.length - 1) break block7;
                ReIterator it = iterator.keyIterator(KeyMode.KNOWN_KEYS_KNOWN_FACTS);
                if (it.reset() > 0L) {
                    while (it.hasNext() && (!deltaOnly || hasDelta)) {
                        this.state[index] = (ValueRow[])it.next();
                        this.testAndSave();
                    }
                }
                if ((it = iterator.keyIterator(KeyMode.NEW_KEYS_NEW_FACTS)).reset() <= 0L) break block8;
                while (it.hasNext()) {
                    this.state[index] = (ValueRow[])it.next();
                    this.testAndSave();
                }
                break block8;
            }
            ReIterator it = iterator.keyIterator(KeyMode.KNOWN_KEYS_KNOWN_FACTS);
            if (it.reset() > 0L) {
                while (it.hasNext()) {
                    this.state[index] = (ValueRow[])it.next();
                    this.evaluate(index + 1, hasDelta, deltaOnly);
                }
            }
            if ((it = iterator.keyIterator(KeyMode.NEW_KEYS_NEW_FACTS)).reset() > 0L) {
                while (it.hasNext()) {
                    this.state[index] = (ValueRow[])it.next();
                    this.evaluate(index + 1, true, deltaOnly);
                }
            }
        }
    }

    private void testAndSave() {
        for (int i = 0; i < this.evaluators.length; ++i) {
            if (this.evaluators[i].test(this.evaluatorValues[i])) continue;
            return;
        }
        this.successData.save(this.saveMapper);
    }

    static class SourceIterator
    implements KeyReIterators<ValueRow[]> {
        private final FactType[] types;
        private final int index;
        private final EnumMap<KeyMode, ReIterator<ValueRow[]>> map;

        SourceIterator(int index, RhsFactGroupDescriptor descriptor, KeyReIterators<ValueRow[]> iterator) {
            this.types = descriptor.getTypes();
            this.index = index;
            this.map = iterator.keyIterators();
        }

        @Override
        public EnumMap<KeyMode, ReIterator<ValueRow[]>> keyIterators() {
            return this.map;
        }
    }

    private static class IntToValueImpl
    implements IntToValue {
        private final ValueRow[][] state;
        private final int[][] addr;

        IntToValueImpl(EvaluatorInternal evaluator, ValueRow[][] state, int[][] conditionMapping) {
            this.state = state;
            FactTypeField[] descriptor = evaluator.descriptor();
            this.addr = new int[descriptor.length][];
            for (int value = 0; value < this.addr.length; ++value) {
                FactTypeField ref = descriptor[value];
                FactType factType = ref.getFactType();
                int[] map = conditionMapping[factType.getInRuleIndex()];
                this.addr[value] = new int[]{map[0], map[1], ref.getFieldIndex()};
            }
        }

        @Override
        public Object apply(int value) {
            int[] map = this.addr[value];
            return this.state[map[0]][map[1]].get(map[2]);
        }
    }
}

