/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.util.Arrays;
import org.evrete.api.ActiveField;
import org.evrete.api.RuntimeFact;
import org.evrete.runtime.evaluation.AlphaEvaluator;

public final class RuntimeObject
implements RuntimeFact {
    private static final boolean[] EMPTY_ALPHA_TESTS = new boolean[0];
    private final Object delegate;
    private Object[] values;
    private boolean[] alphaTests;

    private RuntimeObject(Object o, Object[] values) {
        this(o, values, EMPTY_ALPHA_TESTS);
    }

    private RuntimeObject(Object o, Object[] values, boolean[] alphaTests) {
        this.values = values;
        this.delegate = o;
        this.alphaTests = alphaTests;
    }

    public static RuntimeObject factory(Object o, Object[] values, boolean[] alphaTests) {
        return new RuntimeObject(o, values, alphaTests);
    }

    public static RuntimeObject factory(Object o, Object[] values) {
        return new RuntimeObject(o, values);
    }

    @Override
    public Object apply(ActiveField field) {
        return this.values[field.getValueIndex()];
    }

    @Override
    public boolean[] getAlphaTests() {
        return this.alphaTests;
    }

    @Override
    public <T> T getDelegate() {
        return (T)this.delegate;
    }

    @Override
    public Object[] getValues() {
        return this.values;
    }

    public final void appendValue(ActiveField field, Object value) {
        assert (this.values.length == field.getValueIndex());
        this.values = Arrays.copyOf(this.values, this.values.length + 1);
        this.values[field.getValueIndex()] = value;
    }

    public final void appendAlphaTest(AlphaEvaluator[] newEvaluators) {
        int currentSize = this.alphaTests.length;
        this.alphaTests = Arrays.copyOf(this.alphaTests, currentSize + newEvaluators.length);
        for (int i = 0; i < newEvaluators.length; ++i) {
            int newIndex = currentSize + i;
            AlphaEvaluator newEvaluator = newEvaluators[i];
            assert (newIndex == newEvaluator.getUniqueId());
            Object fieldValue = this.values[newEvaluator.getValueIndex()];
            this.alphaTests[newIndex] = newEvaluator.test(fieldValue);
        }
    }

    public String toString() {
        return "{delegate=" + this.getDelegate() + ", values=" + Arrays.toString(this.values) + ", tests=" + Arrays.toString(this.alphaTests) + '}';
    }
}

