/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.util.ArrayList;
import java.util.function.Function;
import java.util.function.Predicate;
import org.evrete.api.RuntimeRule;
import org.evrete.api.StatefulSession;
import org.evrete.api.ValueRow;
import org.evrete.runtime.AbstractRuntimeRule;
import org.evrete.runtime.ActivationSubject;
import org.evrete.runtime.FactType;
import org.evrete.runtime.RuleDescriptor;
import org.evrete.runtime.RuntimeFactType;
import org.evrete.runtime.RuntimeFactTypeKeyed;
import org.evrete.runtime.RuntimeLhs;
import org.evrete.runtime.memory.BetaEndNode;
import org.evrete.runtime.memory.Buffer;
import org.evrete.runtime.memory.SessionMemory;
import org.evrete.util.CollectionUtils;

public class RuntimeRuleImpl
extends AbstractRuntimeRule
implements RuntimeRule,
ActivationSubject {
    private final RuntimeFactType[] factSources;
    private final RuntimeFactTypeKeyed[] betaFactSources;
    private final SessionMemory memory;
    private final Function<FactType, Predicate<ValueRow>> deletedKeys;
    private final RuleDescriptor descriptor;
    private final RuntimeLhs lhs;
    private final Buffer ruleBuffer;
    private final Buffer memoryBuffer;

    public RuntimeRuleImpl(RuleDescriptor rd, SessionMemory memory) {
        super(memory, rd, rd.getLhs().getGroupFactTypes());
        this.descriptor = rd;
        this.memory = memory;
        FactType[] allFactTypes = this.descriptor.getLhs().getAllFactTypes();
        this.factSources = RuntimeRuleImpl.buildTypes(memory, allFactTypes);
        this.deletedKeys = factType -> {
            RuntimeFactTypeKeyed t = (RuntimeFactTypeKeyed)this.factSources[factType.getInRuleIndex()];
            return valueRow -> t.getKeyStorage().isKeyDeleted((ValueRow)valueRow);
        };
        ArrayList<RuntimeFactTypeKeyed> betaNodes = new ArrayList<RuntimeFactTypeKeyed>(this.factSources.length);
        for (RuntimeFactType t : this.factSources) {
            if (!t.isBetaNode()) continue;
            betaNodes.add((RuntimeFactTypeKeyed)t);
        }
        this.betaFactSources = betaNodes.toArray(new RuntimeFactTypeKeyed[0]);
        this.ruleBuffer = new Buffer();
        this.memoryBuffer = memory.getBuffer();
        this.lhs = RuntimeLhs.factory(this, rd.getLhs(), this.ruleBuffer);
    }

    private static RuntimeFactType[] buildTypes(SessionMemory runtime, FactType[] allFactTypes) {
        RuntimeFactType[] factSources = new RuntimeFactType[allFactTypes.length];
        for (FactType factType : allFactTypes) {
            RuntimeFactType iterable;
            factSources[iterable.getInRuleIndex()] = iterable = RuntimeFactType.factory(factType, runtime);
        }
        return factSources;
    }

    public final void executeRhs() {
        assert (this.isInActiveState());
        this.lhs.forEach(this.rhs);
        this.memoryBuffer.takeAllFrom(this.ruleBuffer);
    }

    public void clear() {
        for (BetaEndNode endNode : this.lhs.getAllBetaEndNodes()) {
            endNode.clear();
        }
    }

    public <T extends RuntimeFactType> T resolve(FactType type) {
        return (T)this.factSources[type.getInRuleIndex()];
    }

    public <Z extends RuntimeFactType> Z[] resolve(Class<Z> type, FactType[] types) {
        RuntimeFactType[] resolved = (RuntimeFactType[])CollectionUtils.array(type, types.length);
        for (int i = 0; i < types.length; ++i) {
            resolved[i] = this.resolve(types[i]);
        }
        return resolved;
    }

    public RuntimeFactType[] getAllFactTypes() {
        return this.factSources;
    }

    public RuleDescriptor getDescriptor() {
        return this.descriptor;
    }

    public SessionMemory getMemory() {
        return this.memory;
    }

    public boolean isDeleteDeltaAvailable() {
        boolean delta = false;
        for (RuntimeFactTypeKeyed ft : this.betaFactSources) {
            if (!ft.isDeleteDeltaAvailable()) continue;
            delta = true;
        }
        return delta;
    }

    public Function<FactType, Predicate<ValueRow>> getDeletedKeys() {
        return this.deletedKeys;
    }

    @Override
    public boolean isInActiveState() {
        return this.lhs.isInActiveState();
    }

    @Override
    public void resetState() {
        this.lhs.resetState();
        for (BetaEndNode endNode : this.lhs.getAllBetaEndNodes()) {
            endNode.mergeDelta();
        }
    }

    @Override
    public StatefulSession getRuntime() {
        return (StatefulSession)((Object)this.memory);
    }

    @Override
    public RuntimeRule addImport(String imp) {
        super.addImport(imp);
        return this;
    }

    public RuntimeLhs getLhs() {
        return this.lhs;
    }

    public String toString() {
        return "RuntimeRule{name=" + this.getName() + '}';
    }
}

