/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime.async;

import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.CountedCompleter;
import java.util.function.Function;

public abstract class Completer
extends CountedCompleter<Void> {
    private boolean directInvoke = false;

    Completer(Completer completer) {
        super(completer);
    }

    Completer() {
    }

    public static Completer of(Collection<? extends Runnable> collection) {
        return Completer.of(null, collection);
    }

    private static Completer of(Completer parent, Collection<? extends Runnable> collection) {
        switch (collection.size()) {
            case 0: {
                throw new UnsupportedOperationException();
            }
            case 1: {
                return new RunnableCompleter(parent, collection.iterator().next());
            }
        }
        return new MultiRunnableCompleter(parent, collection);
    }

    protected abstract void execute();

    boolean isDirectInvoke() {
        return this.directInvoke;
    }

    private void invokeDirect() {
        this.directInvoke = true;
        this.execute();
        this.onCompletion(this);
    }

    @Override
    public final void compute() {
        this.execute();
        this.tryComplete();
    }

    void forkNew(Completer completer) {
        if (this.directInvoke) {
            completer.invokeDirect();
        } else {
            this.addToPendingCount(1);
            completer.fork();
        }
    }

    <Z> void tailCall(Collection<Z> collection, Function<Z, Completer> mapper) {
        if (this.directInvoke) {
            for (Z o : collection) {
                mapper.apply(o).invokeDirect();
            }
        } else {
            Iterator<Z> it = collection.iterator();
            while (it.hasNext()) {
                Z item = it.next();
                Completer c = mapper.apply(item);
                this.addToPendingCount(1);
                if (it.hasNext()) {
                    c.fork();
                    continue;
                }
                c.compute();
            }
        }
    }

    <Z> void tailCall(Z[] collection, Function<Z, Completer> mapper) {
        if (this.directInvoke) {
            for (Z o : collection) {
                mapper.apply(o).invokeDirect();
            }
        } else {
            for (int i = 0; i < collection.length; ++i) {
                Completer c = mapper.apply(collection[i]);
                this.addToPendingCount(1);
                if (i == 0) {
                    c.compute();
                    continue;
                }
                c.fork();
            }
        }
    }

    static class RunnableCompleter
    extends Completer {
        private final Runnable runnable;

        RunnableCompleter(Completer completer, Runnable runnable) {
            super(completer);
            this.runnable = runnable;
        }

        @Override
        protected void execute() {
            this.runnable.run();
        }
    }

    private static class MultiRunnableCompleter
    extends Completer {
        private final Collection<? extends Runnable> collection;

        MultiRunnableCompleter(Completer completer, Collection<? extends Runnable> collection) {
            super(completer);
            assert (collection.size() > 1);
            this.collection = collection;
        }

        @Override
        protected void execute() {
            if (this.isDirectInvoke()) {
                for (Runnable runnable : this.collection) {
                    runnable.run();
                }
            } else {
                Iterator<? extends Runnable> it = this.collection.iterator();
                Runnable runnable = it.next();
                while (it.hasNext()) {
                    this.forkNew(new RunnableCompleter(this, it.next()));
                }
                runnable.run();
            }
        }
    }
}

