/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime.builder;

import java.util.Objects;
import java.util.function.Function;
import org.evrete.api.Evaluator;
import org.evrete.api.IntToValue;
import org.evrete.api.LogicallyComparable;
import org.evrete.api.NamedType;
import org.evrete.runtime.AbstractRuntime;
import org.evrete.runtime.builder.AbstractExpression;
import org.evrete.runtime.builder.FieldReference;

class PredicateExpression0
extends AbstractExpression {
    private final String source;

    PredicateExpression0(String source, double complexity) {
        super(complexity);
        Objects.requireNonNull(source);
        if (complexity <= 0.0) {
            throw new IllegalArgumentException("Complexity must be positive");
        }
        this.source = source;
    }

    PredicateExpression0(String source) {
        this(source, 1.0);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PredicateExpression0 that = (PredicateExpression0)o;
        return this.source.equals(that.source);
    }

    public int hashCode() {
        return Objects.hash(this.source);
    }

    @Override
    Evaluator build(AbstractRuntime<?> runtime, Function<String, NamedType> typeMapper) {
        final Evaluator e = runtime.compile(this.source, typeMapper);
        final double complexity = this.getComplexity();
        if (complexity == 1.0) {
            return e;
        }
        return new Evaluator(){

            @Override
            public FieldReference[] descriptor() {
                return e.descriptor();
            }

            @Override
            public boolean test(IntToValue intToValue) {
                return e.test(intToValue);
            }

            @Override
            public int compare(LogicallyComparable other) {
                return e.compare(other);
            }

            public String toString() {
                return e.toString();
            }

            @Override
            public double getComplexity() {
                return complexity;
            }
        };
    }
}

