/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime.builder;

import java.util.function.Consumer;
import org.evrete.AbstractRule;
import org.evrete.api.FactBuilder;
import org.evrete.api.RhsContext;
import org.evrete.api.RuleBuilder;
import org.evrete.api.RuntimeContext;
import org.evrete.runtime.AbstractRuntime;
import org.evrete.runtime.builder.AggregateLhsBuilder;
import org.evrete.runtime.builder.LhsBuilder;

public class RuleBuilderImpl<C extends RuntimeContext<C>>
extends AbstractRule
implements RuleBuilder<C> {
    private final AbstractRuntime<C> runtime;
    private final LhsBuilder<C> lhsBuilder;

    public RuleBuilderImpl(AbstractRuntime<C> ctx, String name, int defaultSalience) {
        super(name, defaultSalience);
        if (ctx.ruleExists(name)) {
            throw new IllegalStateException("Rule '" + name + "' already exists");
        }
        this.runtime = ctx;
        this.lhsBuilder = new LhsBuilder(this);
    }

    public RuleBuilderImpl<C> compileConditions(AbstractRuntime<?> runtime) {
        this.lhsBuilder.compileConditions(runtime);
        for (AggregateLhsBuilder<C> agg : this.lhsBuilder.getAggregateGroups()) {
            agg.compileConditions(runtime);
        }
        return this;
    }

    @Override
    public RuleBuilderImpl<C> salience(int salience) {
        this.setSalience(salience);
        return this;
    }

    @Override
    public RuleBuilderImpl<C> addImport(String imp) {
        super.addImport(imp);
        return this;
    }

    @Override
    public RuleBuilder<C> addImport(Class<?> type) {
        super.addImport(type);
        return this;
    }

    @Override
    public <Z> RuleBuilder<C> property(String property, Z value) {
        this.set(property, value);
        return this;
    }

    @Override
    public C getRuntime() {
        return (C)this.runtime;
    }

    @Override
    public LhsBuilder<C> getLhs() {
        return this.lhsBuilder;
    }

    C build() {
        switch (this.runtime.getKind()) {
            case SESSION: {
                this.runtime.deployRule(this.runtime.compileRule(this));
                break;
            }
            case KNOWLEDGE: {
                this.runtime.compileRule(this);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return this.getRuntime();
    }

    C build(Consumer<RhsContext> rhs) {
        this.setRhs(rhs);
        return this.build();
    }

    C build(String literalRhs) {
        this.setRhs(literalRhs);
        return this.build();
    }

    @Override
    public LhsBuilder<C> forEach(FactBuilder ... facts) {
        return (LhsBuilder)this.lhsBuilder.buildLhs(facts);
    }

    public AbstractRuntime<?> getRuntimeContext() {
        return this.runtime;
    }
}

