/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime.evaluation;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.evrete.api.ComplexityObject;
import org.evrete.runtime.FactType;
import org.evrete.runtime.FactTypeField;
import org.evrete.runtime.evaluation.EvaluatorInternal;
import org.evrete.util.Bits;

public class EvaluatorGroup
implements ComplexityObject {
    public static final EvaluatorGroup[] ZERO_ARRAY = new EvaluatorGroup[0];
    private final EvaluatorInternal[] evaluators;
    private final Bits typeMask = new Bits();
    private final Set<FactType> descriptor;
    private final double complexity;

    EvaluatorGroup(Collection<EvaluatorInternal> collection) {
        this.evaluators = collection.toArray(EvaluatorInternal.ZERO_ARRAY);
        Arrays.sort(this.evaluators, Comparator.comparingDouble(ComplexityObject::getComplexity));
        HashSet<FactType> factTypes = new HashSet<FactType>();
        double comp = 0.0;
        for (EvaluatorInternal ei : this.evaluators) {
            for (FactTypeField ref : ei.descriptor()) {
                FactType t = ref.getFactType();
                factTypes.add(t);
                this.typeMask.set(t.getInRuleIndex());
            }
            comp += ei.getComplexity();
        }
        this.complexity = comp;
        this.descriptor = Collections.unmodifiableSet(factTypes);
    }

    protected EvaluatorGroup(EvaluatorGroup other) {
        this.evaluators = other.evaluators;
        this.complexity = other.complexity;
        this.descriptor = other.descriptor;
    }

    @Override
    public double getComplexity() {
        return this.complexity;
    }

    public Set<FactType> descriptor() {
        return this.descriptor;
    }

    public EvaluatorInternal[] getEvaluators() {
        return this.evaluators;
    }

    public Bits getTypeMask() {
        return this.typeMask;
    }

    public String toString() {
        return Arrays.toString(this.evaluators);
    }
}

