/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime.memory;

import java.util.function.ObjIntConsumer;
import org.evrete.api.KeysStore;
import org.evrete.api.ReIterator;
import org.evrete.runtime.ConditionNodeDescriptor;
import org.evrete.runtime.RuntimeRuleImpl;
import org.evrete.runtime.memory.AbstractBetaConditionNode;
import org.evrete.runtime.memory.BetaMemoryNode;
import org.evrete.runtime.memory.DefaultStateFactory;
import org.evrete.runtime.memory.NodeIterationState;

public class BetaConditionNode
extends AbstractBetaConditionNode {
    static final BetaConditionNode[] EMPTY_ARRAY = new BetaConditionNode[0];
    private final NodeIterationState state;
    private final boolean nonPlainSources;
    private final ReIterator<KeysStore.Entry>[] entryData;
    private final ReIterator<KeysStore.Entry>[] mainIterators;
    private final ReIterator<KeysStore.Entry>[] deltaIterators;

    BetaConditionNode(RuntimeRuleImpl rule, ConditionNodeDescriptor descriptor, BetaMemoryNode<?>[] sources) {
        super(rule, descriptor, sources);
        DefaultStateFactory stateFactory = new DefaultStateFactory(this);
        this.state = stateFactory.newIterationState();
        this.nonPlainSources = stateFactory.hasNonPlainSources();
        this.entryData = new ReIterator[sources.length];
        this.mainIterators = new ReIterator[sources.length];
        this.deltaIterators = new ReIterator[sources.length];
        for (int source = 0; source < sources.length; ++source) {
            this.mainIterators[source] = sources[source].getMainStore().entries();
            this.deltaIterators[source] = sources[source].getDeltaStore().entries();
        }
    }

    private static void processSecondary(NodeIterationState state, ReIterator<KeysStore.Entry>[] secondary, KeysStore destination) {
        BetaConditionNode.recursiveIteration(0, secondary, state::setSecondaryEntry, () -> state.saveTo(destination));
    }

    private static void recursiveIteration(int sourceIndex, ReIterator<KeysStore.Entry>[] entryData, ObjIntConsumer<KeysStore.Entry> consumer, Runnable endRunnable) {
        ReIterator<KeysStore.Entry> it = entryData[sourceIndex];
        it.reset();
        if (sourceIndex == entryData.length - 1) {
            while (it.hasNext()) {
                consumer.accept((KeysStore.Entry)it.next(), sourceIndex);
                endRunnable.run();
            }
        } else {
            while (it.hasNext()) {
                consumer.accept((KeysStore.Entry)it.next(), sourceIndex);
                BetaConditionNode.recursiveIteration(sourceIndex + 1, entryData, consumer, endRunnable);
            }
        }
    }

    public void computeDelta(boolean deltaOnly) {
        this.evaluateSources(deltaOnly, false, 0);
    }

    private void evaluateSources(boolean deltaOnly, boolean hasDelta, int sourceId) {
        if (sourceId == this.entryData.length - 1) {
            ReIterator<KeysStore.Entry> iterator = this.mainIterators[sourceId];
            if ((hasDelta || !deltaOnly) && iterator.reset() > 0L) {
                this.entryData[sourceId] = iterator;
                this.evaluate();
            }
            if ((iterator = this.deltaIterators[sourceId]).reset() > 0L) {
                this.entryData[sourceId] = iterator;
                this.evaluate();
            }
        } else {
            ReIterator<KeysStore.Entry> iterator = this.mainIterators[sourceId];
            if (iterator.reset() > 0L) {
                this.entryData[sourceId] = iterator;
                this.evaluateSources(deltaOnly, hasDelta, sourceId + 1);
            }
            if ((iterator = this.deltaIterators[sourceId]).reset() > 0L) {
                this.entryData[sourceId] = iterator;
                this.evaluateSources(deltaOnly, true, sourceId + 1);
            }
        }
    }

    private void evaluate() {
        KeysStore destination = this.getDeltaStore();
        if (this.nonPlainSources) {
            this.processInputsNonPlain(destination);
        } else {
            this.processInputsPlain(destination);
        }
    }

    private void processInputsPlain(KeysStore destination) {
        BetaConditionNode.recursiveIteration(0, this.entryData, this.state::setEvaluationEntry, () -> {
            if (this.state.evaluate()) {
                this.state.saveTo(destination);
            }
        });
    }

    private void processInputsNonPlain(KeysStore destination) {
        BetaConditionNode.recursiveIteration(0, this.entryData, this.state::setEvaluationEntry, () -> {
            if (this.state.evaluate()) {
                BetaConditionNode.processSecondary(this.state, this.state.buildSecondary(), destination);
            }
        });
    }
}

