/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime.memory;

import org.evrete.api.KeyMode;
import org.evrete.api.KeysStore;
import org.evrete.api.ReIterator;
import org.evrete.api.ValueRow;
import org.evrete.collections.MappedReIterator;
import org.evrete.runtime.EntryNodeDescriptor;
import org.evrete.runtime.RuntimeFactType;
import org.evrete.runtime.RuntimeFactTypeKeyed;
import org.evrete.runtime.memory.BetaMemoryNode;
import org.evrete.runtime.memory.KeysStoreStub;

public class BetaEntryNode
extends RuntimeFactTypeKeyed
implements BetaMemoryNode<EntryNodeDescriptor> {
    private final KeysStore mainStore;
    private final KeysStore deltaStore;
    private final EntryNodeDescriptor descriptor;
    private final RuntimeFactType[][] grouping;

    BetaEntryNode(EntryNodeDescriptor node, RuntimeFactTypeKeyed factType) {
        super(factType);
        this.descriptor = node;
        this.deltaStore = new KeysStoreDelegate(this.getKeyIterators().keyIterator(KeyMode.NEW_KEYS_NEW_FACTS));
        this.mainStore = new KeysStoreDelegate(this.getKeyIterators().keyIterator(KeyMode.KNOWN_KEYS_KNOWN_FACTS));
        this.grouping = new RuntimeFactType[1][1];
        this.grouping[0][0] = this;
    }

    @Override
    public RuntimeFactType[][] getGrouping() {
        return this.grouping;
    }

    @Override
    public EntryNodeDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public KeysStore getDeltaStore() {
        return this.deltaStore;
    }

    @Override
    public KeysStore getMainStore() {
        return this.mainStore;
    }

    @Override
    public void clear() {
    }

    @Override
    public void mergeDelta() {
    }

    static class KeysStoreDelegate
    extends KeysStoreStub {
        private final ReIterator<KeysStore.Entry> entryReIterator;

        KeysStoreDelegate(ReIterator<ValueRow> storage) {
            DummyEntry entry = new DummyEntry();
            this.entryReIterator = new MappedReIterator<KeysStore.Entry, ValueRow>(storage, valueRows -> {
                entry.arr[0] = valueRows;
                return entry;
            });
        }

        @Override
        public ReIterator<KeysStore.Entry> entries() {
            return this.entryReIterator;
        }
    }

    private static class DummyEntry
    implements KeysStore.Entry {
        final ValueRow[] arr = new ValueRow[1];

        private DummyEntry() {
        }

        @Override
        public ValueRow[] key() {
            return this.arr;
        }

        @Override
        public KeysStore getNext() {
            throw new UnsupportedOperationException();
        }
    }
}

