/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime.memory;

import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.logging.Logger;
import org.evrete.api.BufferedInsert;
import org.evrete.api.Type;
import org.evrete.api.TypeResolver;
import org.evrete.collections.FastIdentityHashSet;
import org.evrete.runtime.memory.Action;

public class Buffer {
    private static final Logger LOGGER = Logger.getLogger(Buffer.class.getName());
    private final EnumMap<Action, TypedObjects> actionData = new EnumMap(Action.class);
    private boolean insertsAvailable = false;
    private boolean deletesAvailable = false;

    public Buffer() {
        for (Action a : Action.values()) {
            this.actionData.put(a, new TypedObjects());
        }
    }

    public void add(TypeResolver resolver, Action action, Collection<?> objects) {
        int objectCount = objects.size();
        TypedObjects deletes = this.actionData.get((Object)Action.RETRACT);
        TypedObjects inserts = this.actionData.get((Object)Action.INSERT);
        switch (action) {
            case INSERT: {
                inserts.ensureExtraCapacity(objectCount);
                for (Object o : objects) {
                    this.insertsAvailable |= inserts.add(resolver, o);
                }
                return;
            }
            case UPDATE: {
                inserts.ensureExtraCapacity(objectCount);
                deletes.ensureExtraCapacity(objectCount);
                for (Object o : objects) {
                    this.insertsAvailable |= inserts.add(resolver, o);
                    this.deletesAvailable |= deletes.add(resolver, o);
                }
                return;
            }
            case RETRACT: {
                deletes.ensureExtraCapacity(objectCount);
                for (Object o : objects) {
                    this.deletesAvailable |= deletes.add(resolver, o);
                }
                return;
            }
        }
        throw new IllegalStateException();
    }

    public void insert(TypeResolver resolver, String objectType, Collection<?> objects) {
        int objectCount = objects.size();
        Type type = resolver.getType(objectType);
        if (type == null) {
            LOGGER.warning("Objects of unknown type '" + objectType + "' will be ignored.");
        }
        TypedObjects inserts = this.actionData.get((Object)Action.INSERT);
        inserts.ensureExtraCapacity(objectCount);
        for (Object o : objects) {
            this.insertsAvailable |= inserts.add(type, o);
        }
    }

    void takeAll(Action action, BiConsumer<Type<?>, Iterator<Object>> consumer) {
        this.actionData.get((Object)action).takeAll(consumer);
    }

    public void takeAllFrom(Buffer other) {
        if (!other.hasTasks()) {
            return;
        }
        this.insertsAvailable |= other.insertsAvailable;
        this.deletesAvailable |= other.deletesAvailable;
        other.actionData.forEach((action, otherObjects) -> {
            TypedObjects myObjects = this.actionData.get(action);
            myObjects.add((TypedObjects)otherObjects);
        });
        other.clear();
    }

    final boolean hasTasks() {
        return this.insertsAvailable || this.deletesAvailable;
    }

    void clear() {
        this.insertsAvailable = false;
        this.deletesAvailable = false;
        for (TypedObjects typedObjects : this.actionData.values()) {
            typedObjects.clear();
        }
    }

    public String toString() {
        return "Buffer{" + this.actionData + '}';
    }

    private static class TypedObjects
    implements BufferedInsert {
        private final Map<Type<?>, FastIdentityHashSet<Object>> data = new HashMap();

        private TypedObjects() {
        }

        boolean add(TypeResolver resolver, Object o) {
            Type type = resolver.resolve(o);
            if (type == null) {
                LOGGER.warning("Object {" + o + "} is of an unknown type '" + o.getClass() + "' and will be ignored.");
                return false;
            }
            return this.data.computeIfAbsent(type, t -> new FastIdentityHashSet()).add(o);
        }

        boolean add(Type<?> type, Object o) {
            return this.data.computeIfAbsent(type, t -> new FastIdentityHashSet()).add(o);
        }

        void takeAll(BiConsumer<Type<?>, Iterator<Object>> consumer) {
            for (Map.Entry<Type<?>, FastIdentityHashSet<Object>> entry : this.data.entrySet()) {
                FastIdentityHashSet<Object> set = entry.getValue();
                Type<?> t = entry.getKey();
                consumer.accept(t, set.iterator());
                set.clear();
            }
        }

        @Override
        public void ensureExtraCapacity(int insertCount) {
            for (FastIdentityHashSet<Object> set : this.data.values()) {
                set.ensureExtraCapacity(insertCount);
            }
        }

        void add(TypedObjects other) {
            for (Map.Entry<Type<?>, FastIdentityHashSet<Object>> entry : other.data.entrySet()) {
                this.data.computeIfAbsent(entry.getKey(), k -> new FastIdentityHashSet()).bulkAdd(entry.getValue());
            }
        }

        void clear() {
            for (FastIdentityHashSet<Object> set : this.data.values()) {
                set.clear();
            }
        }
    }
}

