/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime.memory;

import org.evrete.runtime.FactType;
import org.evrete.runtime.RuntimeFactTypeKeyed;
import org.evrete.runtime.evaluation.EvaluatorGroup;
import org.evrete.runtime.memory.BetaConditionNode;
import org.evrete.runtime.memory.BetaMemoryNode;
import org.evrete.runtime.memory.NodeIterationState;
import org.evrete.runtime.memory.NodeIterationStateFactory;
import org.evrete.util.CollectionUtils;

public class DefaultStateFactory
implements NodeIterationStateFactory<NodeIterationState, EvaluatorGroup> {
    private final BetaConditionNode node;
    private final int[][][] destinationData;
    private final boolean nonPlainSources;

    public DefaultStateFactory(BetaConditionNode node) {
        this.node = node;
        int[] nonPlainSourceIndices = node.getNonPlainSourceIndices();
        this.nonPlainSources = nonPlainSourceIndices.length > 0;
        BetaMemoryNode<?>[] sources = node.getSources();
        FactType[][] primaryFactTypes = new FactType[sources.length][];
        for (BetaMemoryNode<?> source : sources) {
            primaryFactTypes[source.getSourceIndex()] = source.getGrouping()[0];
        }
        FactType[][] secondaryFactTypes = new FactType[nonPlainSourceIndices.length][];
        for (int z = 0; z < nonPlainSourceIndices.length; ++z) {
            BetaMemoryNode<?> source;
            int nonPlainSourceId = nonPlainSourceIndices[z];
            source = sources[nonPlainSourceId];
            secondaryFactTypes[z] = source.getGrouping()[1];
        }
        RuntimeFactTypeKeyed[][] grouping = node.getGrouping();
        int totalLevels = grouping.length;
        this.destinationData = new int[totalLevels][][];
        for (int level = 0; level < totalLevels; ++level) {
            RuntimeFactTypeKeyed[] levelTypes = grouping[level];
            int[][] locations = new int[levelTypes.length][];
            for (int typeArrIndex = 0; typeArrIndex < levelTypes.length; ++typeArrIndex) {
                int[] addr;
                RuntimeFactTypeKeyed t = levelTypes[typeArrIndex];
                int[] loc = CollectionUtils.locate2(t, primaryFactTypes, FactType.EQUALITY_BY_INDEX);
                if (loc != null) {
                    addr = new int[]{0, loc[0], loc[1]};
                } else {
                    loc = CollectionUtils.locate2(t, secondaryFactTypes, FactType.EQUALITY_BY_INDEX);
                    if (loc == null) {
                        throw new IllegalStateException();
                    }
                    addr = new int[]{1, loc[0], loc[1]};
                }
                locations[typeArrIndex] = addr;
            }
            this.destinationData[level] = locations;
        }
    }

    @Override
    public boolean hasNonPlainSources() {
        return this.nonPlainSources;
    }

    @Override
    public NodeIterationState newIterationState() {
        return new NodeIterationState(this.node, this.destinationData);
    }
}

