/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime.memory;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import java.util.logging.Logger;
import org.evrete.api.ActiveField;
import org.evrete.api.FieldsKey;
import org.evrete.api.ReIterator;
import org.evrete.api.RuntimeFact;
import org.evrete.api.Type;
import org.evrete.collections.AbstractFastHashMap;
import org.evrete.collections.ArrayOf;
import org.evrete.collections.FastIdentityHashMap;
import org.evrete.runtime.PlainMemory;
import org.evrete.runtime.RuntimeObject;
import org.evrete.runtime.evaluation.AlphaBucketMeta;
import org.evrete.runtime.evaluation.AlphaConditions;
import org.evrete.runtime.evaluation.AlphaDelta;
import org.evrete.runtime.evaluation.AlphaEvaluator;
import org.evrete.runtime.memory.FieldsMemory;
import org.evrete.runtime.memory.SessionMemory;
import org.evrete.runtime.memory.TypeMemoryBucket;

public final class TypeMemory
implements PlainMemory {
    private static final Logger LOGGER = Logger.getLogger(TypeMemory.class.getName());
    private final AlphaConditions alphaConditions;
    private final Map<FieldsKey, FieldsMemory> betaMemories = new HashMap<FieldsKey, FieldsMemory>();
    private final SessionMemory runtime;
    private final Type<?> type;
    private final IdentityMap mainFacts;
    private final IdentityMap deltaFacts;
    private final ArrayOf<TypeMemoryBucket> alphaBuckets;
    private final List<RuntimeObject> insertBuffer = new LinkedList<RuntimeObject>();
    private final List<RuntimeFact> deleteBuffer = new LinkedList<RuntimeFact>();
    private ActiveField[] cachedActiveFields;
    private AlphaEvaluator[] cachesAlphaEvaluators;

    TypeMemory(SessionMemory runtime, Type<?> type) {
        this.runtime = runtime;
        this.alphaConditions = runtime.getAlphaConditions();
        this.type = type;
        this.mainFacts = new IdentityMap();
        this.deltaFacts = new IdentityMap();
        this.alphaBuckets = new ArrayOf<TypeMemoryBucket>(TypeMemoryBucket.class);
        this.cachedActiveFields = runtime.getActiveFields(type);
        this.cachesAlphaEvaluators = (AlphaEvaluator[])this.alphaConditions.getPredicates(type).data;
    }

    public final Set<FieldsKey> knownFieldSets() {
        return Collections.unmodifiableSet(this.betaMemories.keySet());
    }

    void clear() {
        this.mainFacts.clear();
        this.deltaFacts.clear();
        for (TypeMemoryBucket bucket : (TypeMemoryBucket[])this.alphaBuckets.data) {
            bucket.clear();
        }
        for (FieldsMemory fm : this.betaMemories.values()) {
            fm.clear();
        }
    }

    public final FieldsMemory get(FieldsKey fields) {
        FieldsMemory fm = this.betaMemories.get(fields);
        if (fm == null) {
            throw new IllegalArgumentException("No key memory exists for " + fields);
        }
        return fm;
    }

    @Override
    public boolean hasChanges() {
        return this.deltaFacts.size() > 0;
    }

    @Override
    public void commitChanges() {
        if (this.deltaFacts.size() > 0) {
            this.mainFacts.bulkAdd(this.deltaFacts);
            this.deltaFacts.clear();
        }
        for (TypeMemoryBucket bucket : (TypeMemoryBucket[])this.alphaBuckets.data) {
            bucket.commitChanges();
        }
    }

    @Override
    public ReIterator<RuntimeFact> mainIterator() {
        return this.mainFacts.factIterator();
    }

    @Override
    public ReIterator<RuntimeFact> deltaIterator() {
        return this.deltaFacts.factIterator();
    }

    public PlainMemory get(AlphaBucketMeta alphaMask) {
        if (alphaMask.isEmpty()) {
            return this;
        }
        int bucketIndex = alphaMask.getBucketIndex();
        if (bucketIndex >= ((TypeMemoryBucket[])this.alphaBuckets.data).length) {
            throw new IllegalStateException("No alpha memory initialized for " + alphaMask + ", type: " + this.type);
        }
        TypeMemoryBucket bucket = ((TypeMemoryBucket[])this.alphaBuckets.data)[bucketIndex];
        if (bucket == null) {
            throw new IllegalStateException("No alpha memory initialized for " + alphaMask + ", type: " + this.type);
        }
        return bucket;
    }

    final void commitInsert() {
        if (this.insertBuffer.isEmpty()) {
            return;
        }
        for (TypeMemoryBucket bucket : (TypeMemoryBucket[])this.alphaBuckets.data) {
            bucket.insert(this.insertBuffer);
        }
        for (FieldsMemory fm : this.fieldsMemories()) {
            fm.insert(this.insertBuffer);
        }
        this.insertBuffer.clear();
    }

    void onNewActiveField(ActiveField newField) {
        for (IdentityMap map : new IdentityMap[]{this.mainFacts, this.deltaFacts}) {
            ReIterator<RuntimeObject> it = map.factImplIterator();
            while (it.hasNext()) {
                RuntimeObject rto = (RuntimeObject)it.next();
                Object fieldValue = newField.readValue(rto.getDelegate());
                rto.appendValue(newField, fieldValue);
            }
        }
        this.cachedActiveFields = this.runtime.getActiveFields(this.type);
    }

    void touchMemory(FieldsKey key, AlphaBucketMeta alphaMeta) {
        if (key.size() == 0) {
            this.touchAlphaMemory(alphaMeta);
        } else {
            this.betaMemories.computeIfAbsent(key, k -> new FieldsMemory(this.runtime, key)).touchMemory(alphaMeta);
        }
    }

    private TypeMemoryBucket touchAlphaMemory(AlphaBucketMeta alphaMeta) {
        int bucketIndex;
        if (!alphaMeta.isEmpty() && this.alphaBuckets.isEmptyAt(bucketIndex = alphaMeta.getBucketIndex())) {
            TypeMemoryBucket newBucket = new TypeMemoryBucket(this.runtime, alphaMeta);
            this.alphaBuckets.set(bucketIndex, newBucket);
            return newBucket;
        }
        return null;
    }

    void onNewAlphaBucket(AlphaDelta delta) {
        if (this.deltaFacts.size() > 0) {
            throw new UnsupportedOperationException("A new condition was created in an uncommitted memory.");
        }
        ReIterator<RuntimeObject> existingFacts = this.mainFacts.factImplIterator();
        AlphaEvaluator[] newEvaluators = delta.getNewEvaluators();
        if (newEvaluators.length > 0 && existingFacts.reset() > 0L) {
            while (existingFacts.hasNext()) {
                ((RuntimeObject)existingFacts.next()).appendAlphaTest(newEvaluators);
            }
        }
        FieldsKey key = delta.getKey();
        AlphaBucketMeta alphaMeta = delta.getNewAlphaMeta();
        if (key.size() == 0) {
            TypeMemoryBucket newBucket = this.touchAlphaMemory(alphaMeta);
            assert (newBucket != null);
            newBucket.fillMainStorage(existingFacts);
        } else {
            this.betaMemories.computeIfAbsent(key, k -> new FieldsMemory(this.runtime, key)).onNewAlphaBucket(alphaMeta, existingFacts);
        }
        this.cachesAlphaEvaluators = (AlphaEvaluator[])this.alphaConditions.getPredicates(this.type).data;
    }

    void commitMemoryDeltas() {
        this.commitChanges();
        for (TypeMemoryBucket b : (TypeMemoryBucket[])this.alphaBuckets.data) {
            b.commitChanges();
        }
        for (FieldsMemory fm : this.betaMemories.values()) {
            fm.commitChanges();
        }
    }

    final void doDelete() {
        if (this.deleteBuffer.isEmpty()) {
            return;
        }
        for (TypeMemoryBucket bucket : (TypeMemoryBucket[])this.alphaBuckets.data) {
            bucket.retract(this.deleteBuffer);
        }
        for (FieldsMemory fm : this.fieldsMemories()) {
            fm.retract(this.deleteBuffer);
        }
        this.deleteBuffer.clear();
    }

    private Collection<FieldsMemory> fieldsMemories() {
        return this.betaMemories.values();
    }

    void deleteSingle(Object fact) {
        RuntimeFact rtf = (RuntimeFact)this.mainFacts.remove(fact);
        if (rtf != null) {
            this.deleteBuffer.add(rtf);
        }
    }

    final <T> void forEachMemoryObject(Consumer<T> consumer) {
        this.mainFacts.forEachKey(f -> consumer.accept(f));
    }

    final void forEachObjectUnchecked(Consumer<Object> consumer) {
        this.mainFacts.forEachKey(consumer);
    }

    final void insertSingle(Object o) {
        RuntimeObject rto = this.register(o);
        this.insertBuffer.add(rto);
    }

    private RuntimeObject register(Object o) {
        RuntimeObject rto;
        Object[] values = new Object[this.cachedActiveFields.length];
        for (int i = 0; i < this.cachedActiveFields.length; ++i) {
            values[i] = this.cachedActiveFields[i].readValue(o);
        }
        if (this.cachesAlphaEvaluators.length > 0) {
            boolean[] alphaTests = new boolean[this.cachesAlphaEvaluators.length];
            for (AlphaEvaluator alpha : this.cachesAlphaEvaluators) {
                int fieldInUseIndex = alpha.getValueIndex();
                alphaTests[alpha.getUniqueId()] = alpha.test(values[fieldInUseIndex]);
            }
            rto = RuntimeObject.factory(o, values, alphaTests);
        } else {
            rto = RuntimeObject.factory(o, values);
        }
        if (this.mainFacts.contains(o) || this.deltaFacts.contains(o)) {
            LOGGER.warning("Object " + o + " has been already inserted, skipping insert");
            return null;
        }
        this.deltaFacts.put(o, rto);
        return rto;
    }

    private static class IdentityMap
    extends FastIdentityHashMap<Object, RuntimeObject> {
        private static final ToIntFunction<Object> HASH = System::identityHashCode;
        private static final Function<AbstractFastHashMap.Entry<Object, RuntimeObject>, RuntimeFact> MAPPER = AbstractFastHashMap.Entry::getValue;
        private static final Function<AbstractFastHashMap.Entry<Object, RuntimeObject>, RuntimeObject> MAPPER_IMPL = AbstractFastHashMap.Entry::getValue;
        private static final BiPredicate<Object, Object> EQ = (fact1, fact2) -> fact1 == fact2;

        private IdentityMap() {
        }

        ReIterator<RuntimeFact> factIterator() {
            return this.iterator(MAPPER);
        }

        ReIterator<RuntimeObject> factImplIterator() {
            return this.iterator(MAPPER_IMPL);
        }

        @Override
        protected ToIntFunction<Object> keyHashFunction() {
            return HASH;
        }

        @Override
        protected BiPredicate<Object, Object> keyHashEquals() {
            return EQ;
        }

        boolean contains(Object o) {
            return this.get(o) != null;
        }
    }
}

