/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.spi.minimal;

import java.util.ArrayList;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.evrete.api.Evaluator;
import org.evrete.api.ExpressionResolver;
import org.evrete.api.NamedType;
import org.evrete.api.RuntimeContext;
import org.evrete.api.Type;
import org.evrete.api.TypeField;
import org.evrete.runtime.builder.FieldReference;
import org.evrete.spi.minimal.ConditionStringTerm;
import org.evrete.spi.minimal.Const;
import org.evrete.spi.minimal.EvaluatorCompiler;
import org.evrete.spi.minimal.FieldReferenceImpl;
import org.evrete.spi.minimal.StringLiteralRemover;
import org.evrete.spi.minimal.TypeImpl;
import org.evrete.util.NextIntSupplier;

class DefaultExpressionResolver
implements ExpressionResolver {
    private static final Pattern REFERENCE_PATTERN = Pattern.compile("\\$[a-zA-Z0-9]+(\\.[a-zA-Z][a-zA-Z0-9]*)+");
    private final EvaluatorCompiler evaluatorCompiler;

    DefaultExpressionResolver(RuntimeContext<?> requester) {
        this.evaluatorCompiler = new EvaluatorCompiler(requester.getClassLoader());
    }

    @Override
    public FieldReference resolve(String s, Function<String, NamedType> resolver) {
        int firstDot = s.indexOf(46);
        if (firstDot < 0) {
            throw new IllegalArgumentException("No field detected in '" + s + "'. The minimal implementation expects type and field, e.g. '$a.customer.id'");
        }
        String lhsFactTYpe = s.substring(0, firstDot);
        String dottedProp = s.substring(firstDot + 1);
        Const.assertName(dottedProp);
        Const.assertName(lhsFactTYpe.substring(1));
        NamedType typeRef = resolver.apply(lhsFactTYpe);
        if (typeRef == null) {
            throw new IllegalArgumentException("There's no declared reference '" + lhsFactTYpe + "' in provided context.");
        }
        Type<?> type = typeRef.getType();
        TypeField field = type.getField(dottedProp);
        if (field == null) {
            if (type instanceof TypeImpl) {
                field = ((TypeImpl)type).inspectClass(dottedProp);
            }
            if (field == null) {
                throw new IllegalArgumentException("Unable to resolve property '" + dottedProp + "' of " + type);
            }
        }
        return new FieldReferenceImpl(typeRef, field);
    }

    @Override
    public synchronized Evaluator buildExpression(String rawExpression, Function<String, NamedType> resolver) {
        StringLiteralRemover remover = StringLiteralRemover.of(rawExpression);
        String strippedExpression = remover.getConverted();
        Matcher m = REFERENCE_PATTERN.matcher(strippedExpression);
        ArrayList<ConditionStringTerm> terms = new ArrayList<ConditionStringTerm>();
        NextIntSupplier fieldCounter = new NextIntSupplier();
        while (m.find()) {
            int end;
            int matcherEnd = m.end();
            int start = m.start();
            if (matcherEnd == strippedExpression.length()) {
                end = matcherEnd;
            } else {
                char next = strippedExpression.charAt(matcherEnd);
                if (next == '(') {
                    end = strippedExpression.lastIndexOf(46);
                    if (end < 0) {
                        throw new IllegalStateException("Something went wrong");
                    }
                } else {
                    end = matcherEnd;
                }
            }
            String s = strippedExpression.substring(start, end);
            FieldReference fieldReference = this.resolve(s, resolver);
            ConditionStringTerm t = new ConditionStringTerm(start, end, fieldReference, fieldCounter);
            terms.add(t);
        }
        return this.evaluatorCompiler.buildExpression(remover, strippedExpression, terms);
    }
}

