/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.util;

import java.util.BitSet;
import java.util.Collection;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.evrete.api.Copyable;
import org.evrete.api.Masked;

public class Bits
implements Copyable<Bits>,
Masked {
    private final BitSet delegate;

    private Bits(BitSet delegate) {
        this.delegate = delegate;
    }

    public Bits() {
        this(new BitSet());
    }

    public static <T> Set<T> matchesOR(Bits mask, Collection<T> collection, Function<T, Bits> maskFunction) {
        return collection.stream().filter(node -> ((Bits)maskFunction.apply(node)).intersects(mask)).collect(Collectors.toSet());
    }

    public static <T extends Masked> Bits or(Collection<T> collection) {
        return Bits.or(collection, Masked::getMask);
    }

    private static <T> Bits or(Collection<T> collection, Function<T, Bits> mapping) {
        Bits b = new Bits();
        for (T o : collection) {
            b.or(mapping.apply(o));
        }
        return b;
    }

    @Override
    public Bits getMask() {
        return this;
    }

    public void or(Bits other) {
        this.delegate.or(other.delegate);
    }

    public void set(int index) {
        this.delegate.set(index);
    }

    public boolean intersects(Bits other) {
        return this.delegate.intersects(other.delegate);
    }

    public void clear() {
        this.delegate.clear();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Bits bits = (Bits)o;
        return this.delegate.equals(bits.delegate);
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public Bits copyOf() {
        return new Bits((BitSet)this.delegate.clone());
    }

    public String toString() {
        return this.delegate.toString();
    }
}

