/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.util;

import java.util.Set;
import org.evrete.util.NextIntSupplier;

public class Node<T extends Node<?>> {
    private static final int DEFAULT_ID = -1;
    private final int index;
    private int sourceIndex = -1;

    protected Node(NextIntSupplier idSupplier, Set<? extends T> sourceNodes) {
        this(idSupplier);
        int sourceIndex = 0;
        for (Node source : sourceNodes) {
            source.setSourceIndex(sourceIndex);
            ++sourceIndex;
        }
    }

    protected Node(NextIntSupplier idSupplier) {
        this.index = idSupplier.next();
    }

    protected final int getIndex() {
        return this.index;
    }

    public int getSourceIndex() {
        return this.sourceIndex;
    }

    final void setSourceIndex(int index) {
        if (this.sourceIndex != -1) {
            throw new IllegalStateException(this.toString());
        }
        this.sourceIndex = index;
    }
}

