/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.collections;

import java.lang.invoke.LambdaMetafactory;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.evrete.api.MapEntry;
import org.evrete.api.ReIterator;
import org.evrete.collections.AbstractLinearHashMapBase;
import org.evrete.collections.HashEntry;

public abstract class AbstractLinearHashMap<K, V>
extends AbstractLinearHashMapBase<K, Entry<K, V>> {
    private static final int DEFAULT_INITIAL_SIZE = 16;

    AbstractLinearHashMap() {
        this(16);
    }

    AbstractLinearHashMap(int initialCapacity) {
        super(initialCapacity);
    }

    public ReIterator<K> keyIterator() {
        return this.iterator(kvEntry -> kvEntry.key);
    }

    public ReIterator<V> valueIterator() {
        return this.iterator(kvEntry -> kvEntry.value);
    }

    public V put(K key, V value) {
        int addr = this.getStorePosition(key, true);
        Entry prev = (Entry)this.data[addr];
        if (prev == null) {
            this.data[addr] = new Entry<K, V>(key, value);
            this.addNew(addr);
            ++this.size;
            return null;
        }
        Object v = prev.value;
        prev.value = value;
        if (this.deletedIndices[addr]) {
            this.deletedIndices[addr] = false;
            ++this.size;
            --this.deletes;
        }
        return (V)v;
    }

    public V remove(K key) {
        Entry e = (Entry)super.removeKey(key);
        return e == null ? null : (V)e.value;
    }

    public V get(K key) {
        Entry found = (Entry)this.getEntry(key);
        return found == null ? null : (V)found.value;
    }

    public final void forEachEntry(BiConsumer<K, V> consumer) {
        this.forEachDataEntry(e -> consumer.accept(e.key, e.value));
    }

    public final void forEachValue(Consumer<V> consumer) {
        this.forEachDataEntry(e -> consumer.accept(e.value));
    }

    public void forEachKey(Consumer<K> consumer) {
        this.forEachDataEntry(e -> consumer.accept(e.key));
    }

    public final V computeIfAbsent(K key, Function<K, V> function) {
        return (V)super.computeEntryIfAbsent(key, (Function<Object, Entry>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$computeIfAbsent$5(java.util.function.Function java.lang.Object ), (Ljava/lang/Object;)Lorg/evrete/collections/AbstractLinearHashMap$Entry;)(function)).value;
    }

    private static /* synthetic */ Entry lambda$computeIfAbsent$5(Function function, Object k) {
        return new Entry(k, function.apply(k));
    }

    public static class Entry<K1, V1>
    extends HashEntry<K1>
    implements MapEntry<K1, V1> {
        V1 value;

        Entry(K1 key, V1 value) {
            super(key);
            this.value = value;
        }

        @Override
        public V1 getValue() {
            return this.value;
        }

        @Override
        public K1 getKey() {
            return (K1)this.key;
        }

        public String toString() {
            return "{" + this.key + "=" + this.value + '}';
        }
    }
}

