/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.collections;

import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import org.evrete.collections.AbstractLinearHash;
import org.evrete.collections.HashEntry;

public abstract class AbstractLinearHashMapBase<K, E extends HashEntry<K>>
extends AbstractLinearHash<E> {
    AbstractLinearHashMapBase(int initialCapacity) {
        super(initialCapacity);
    }

    protected abstract ToIntFunction<K> keyHashFunction();

    protected abstract BiPredicate<K, K> keyHashEquals();

    @Override
    protected final ToIntFunction<Object> getHashFunction() {
        return value -> this.keyHashFunction().applyAsInt(((HashEntry)value).key);
    }

    @Override
    protected final BiPredicate<Object, Object> getEqualsPredicate() {
        return (o1, o2) -> this.keyHashEquals().test(((HashEntry)o1).key, ((HashEntry)o2).key);
    }

    final int getStorePosition(K key, boolean resize) {
        if (resize) {
            super.resize();
        }
        int hash = this.keyHashFunction().applyAsInt(key);
        Predicate<Object> predicate = o -> this.keyHashEquals().test(key, ((HashEntry)o).key);
        return this.findBinIndexFor(hash, predicate);
    }

    E removeKey(K key) {
        int addr = this.getStorePosition(key, true);
        HashEntry found = (HashEntry)this.data[addr];
        if (found == null) {
            return null;
        }
        if (this.deletedIndices[addr]) {
            return null;
        }
        this.deletedIndices[addr] = true;
        --this.size;
        ++this.deletes;
        return (E)found;
    }

    E getEntry(K key) {
        int addr = this.getStorePosition(key, false);
        return (E)((HashEntry)this.get(addr));
    }

    final E computeEntryIfAbsent(K key, Function<K, E> function) {
        int addr = this.getStorePosition(key, true);
        HashEntry found = (HashEntry)this.get(addr);
        if (found == null) {
            found = (HashEntry)function.apply(key);
            super.saveDirect(found, addr);
        }
        return (E)found;
    }
}

