/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.collections;

import java.util.Arrays;
import java.util.function.Supplier;
import org.evrete.util.CollectionUtils;

public class ArrayOf<T> {
    public T[] data;

    public ArrayOf(T[] data) {
        this.data = data;
    }

    public ArrayOf(ArrayOf<T> other) {
        this.data = Arrays.copyOf(other.data, other.data.length);
    }

    public ArrayOf(Class<T> type) {
        this(CollectionUtils.array(type, 0));
    }

    public int append(T element) {
        int ret = this.data.length;
        this.data = Arrays.copyOf(this.data, ret + 1);
        this.data[ret] = element;
        return ret;
    }

    public void set(int index, T element) {
        if (index >= this.data.length) {
            this.data = Arrays.copyOf(this.data, index + 1);
        }
        this.data[index] = element;
    }

    public boolean isEmptyAt(int index) {
        if (index >= this.data.length) {
            return true;
        }
        return this.data[index] == null;
    }

    public T getChecked(int i) {
        if (i >= this.data.length || i < 0) {
            throw new IllegalStateException("No data initialized for " + i);
        }
        T t = this.data[i];
        if (t == null) {
            throw new IllegalStateException("No data initialized for " + i);
        }
        return t;
    }

    public T computeIfAbsent(int bucketIndex, Supplier<T> supplier) {
        T t = this.data[bucketIndex];
        if (t == null) {
            this.data[bucketIndex] = t = supplier.get();
        }
        return t;
    }

    public String toString() {
        return Arrays.toString(this.data);
    }
}

