/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.collections;

import java.util.function.Predicate;
import org.evrete.api.EachRunnable;
import org.evrete.api.ReIterable;
import org.evrete.api.ReIterator;

public class NestedReIterator<T>
implements EachRunnable {
    private final ReIterator<T>[] iterators;
    private final T[] state;
    private final int lastIndex;
    private final Predicate<T> filter;

    public NestedReIterator(T[] state, Predicate<T> filter) {
        this.iterators = new ReIterator[state.length];
        this.state = state;
        this.lastIndex = state.length - 1;
        this.filter = filter;
    }

    public <I extends ReIterable<T>> void setIterables(I[] data) {
        for (int i = 0; i < data.length; ++i) {
            this.set(i, data[i].iterator());
        }
    }

    public long reset() {
        long l = 1L;
        for (ReIterator<T> it : this.iterators) {
            l *= it.reset();
        }
        return l;
    }

    public <I extends ReIterator<T>> void setIterators(I[] data) {
        for (int i = 0; i < data.length; ++i) {
            this.set(i, (ReIterator<T>)data[i]);
        }
    }

    private void set(int index, ReIterator<T> iterator) {
        this.iterators[index] = iterator;
    }

    @Override
    public void runForEach(Runnable r) {
        this.runForEach(0, r);
    }

    protected boolean set(int index, T obj) {
        if (this.filter.test(obj)) {
            this.state[index] = obj;
            return true;
        }
        return false;
    }

    private void runForEach(int index, Runnable r) {
        ReIterator<T> it = this.iterators[index];
        if (it.reset() == 0L) {
            return;
        }
        if (index == this.lastIndex) {
            while (it.hasNext()) {
                if (!this.set(index, it.next())) continue;
                r.run();
            }
        } else {
            while (it.hasNext()) {
                if (!this.set(index, it.next())) continue;
                this.runForEach(index + 1, r);
            }
        }
    }
}

