/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.util.ArrayList;
import java.util.Arrays;
import org.evrete.runtime.AbstractLhsDescriptor;
import org.evrete.runtime.FactType;
import org.evrete.runtime.RhsFactGroupDescriptor;
import org.evrete.runtime.evaluation.EvaluatorGroup;

public class AggregateEvaluator
extends EvaluatorGroup {
    private final LevelData[] levelData;
    private final FactType[][] grouping;

    /*
     * WARNING - void declaration
     */
    public AggregateEvaluator(EvaluatorGroup delegate) {
        super(delegate);
        void var4_9;
        void var4_7;
        int maxLevel = Integer.MIN_VALUE;
        for (FactType factType : delegate.descriptor()) {
            int level = factType.getFactGroup().getLhsDescriptor().getLevel();
            maxLevel = Math.max(maxLevel, level);
        }
        RhsFactGroupDescriptor[] lastGroupDescriptors = new RhsFactGroupDescriptor[maxLevel + 1];
        for (FactType t : delegate.descriptor()) {
            int level = t.getFactGroup().getLhsDescriptor().getLevel();
            RhsFactGroupDescriptor groupDescriptor = t.getFactGroup();
            RhsFactGroupDescriptor existing = lastGroupDescriptors[level];
            if (existing == null) {
                lastGroupDescriptors[level] = groupDescriptor;
                continue;
            }
            if (existing.getKeyGroupIndex() >= groupDescriptor.getKeyGroupIndex()) continue;
            lastGroupDescriptors[level] = groupDescriptor;
        }
        this.levelData = new LevelData[lastGroupDescriptors.length];
        boolean bl = false;
        while (var4_7 < lastGroupDescriptors.length) {
            this.levelData[var4_7] = new LevelData(lastGroupDescriptors[var4_7]);
            ++var4_7;
        }
        this.grouping = new FactType[this.levelData.length][];
        boolean bl2 = false;
        while (var4_9 < this.levelData.length) {
            this.grouping[var4_9] = this.levelData[var4_9].factTypeSequence;
            ++var4_9;
        }
    }

    public LevelData[] getLevelData() {
        return this.levelData;
    }

    public FactType[][] getGrouping() {
        return this.grouping;
    }

    public static class LevelData {
        private final RhsFactGroupDescriptor[] keyGroupSequence;
        private final FactType[] factTypeSequence;

        private LevelData(RhsFactGroupDescriptor lastDescriptor) {
            RhsFactGroupDescriptor[] allGroups;
            ArrayList<RhsFactGroupDescriptor> keySeq = new ArrayList<RhsFactGroupDescriptor>();
            ArrayList<FactType> typeSeq = new ArrayList<FactType>();
            AbstractLhsDescriptor lhs = lastDescriptor.getLhsDescriptor();
            for (RhsFactGroupDescriptor g : allGroups = lhs.getAllFactGroups()) {
                if (g.isLooseGroup()) continue;
                keySeq.add(g);
                typeSeq.addAll(Arrays.asList(g.getTypes()));
                if (g == lastDescriptor) break;
            }
            this.keyGroupSequence = keySeq.toArray(RhsFactGroupDescriptor.ZERO_ARRAY);
            this.factTypeSequence = typeSeq.toArray(FactType.ZERO_ARRAY);
        }

        public RhsFactGroupDescriptor[] getKeyGroupSequence() {
            return this.keyGroupSequence;
        }

        public FactType[] getFactTypeSequence() {
            return this.factTypeSequence;
        }
    }
}

