/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.evrete.api.Masked;
import org.evrete.runtime.FactType;
import org.evrete.util.Bits;
import org.evrete.util.CollectionUtils;
import org.evrete.util.NextIntSupplier;
import org.evrete.util.Node;

public abstract class NodeDescriptor
extends Node<NodeDescriptor>
implements Masked {
    private final Bits mask = new Bits();
    private final NodeDescriptor[] sources;
    private final FactType[] factTypes;
    private FactType[][] evalGrouping = null;

    NodeDescriptor(NextIntSupplier idSupplier, Set<? extends NodeDescriptor> sources) {
        super(idSupplier, sources);
        this.sources = CollectionUtils.array(NodeDescriptor.class, sources.size());
        HashSet<FactType> types = new HashSet<FactType>();
        for (NodeDescriptor nodeDescriptor : sources) {
            types.addAll(Arrays.asList(nodeDescriptor.factTypes));
            this.sources[nodeDescriptor.getSourceIndex()] = nodeDescriptor;
        }
        for (FactType t : this.factTypes = FactType.toArray(types)) {
            this.mask.set(t.getInRuleIndex());
        }
    }

    NodeDescriptor(NextIntSupplier idSupplier, FactType entryType) {
        super(idSupplier);
        this.sources = new NodeDescriptor[0];
        this.factTypes = new FactType[]{entryType};
        this.mask.set(entryType.getInRuleIndex());
    }

    private static boolean assertGrouping(FactType[] allTypes, FactType[][] grouping) {
        HashSet<FactType> all = new HashSet<FactType>();
        for (FactType[] betaFactTypes : grouping) {
            all.addAll(Arrays.asList(betaFactTypes));
        }
        Object[] allArr = FactType.toArray(all);
        Object[] allCopy = FactType.toArray(Arrays.asList(allTypes));
        return Arrays.equals(allArr, allCopy);
    }

    public abstract boolean isConditionNode();

    @Override
    public Bits getMask() {
        return this.mask;
    }

    public FactType[] getTypes() {
        return this.factTypes;
    }

    public FactType[][] getEvalGrouping() {
        return this.evalGrouping;
    }

    void setEvalGrouping(FactType[][] grouping) {
        if (this.evalGrouping == null) {
            assert (NodeDescriptor.assertGrouping(this.factTypes, grouping));
        } else {
            throw new IllegalStateException(this.toString());
        }
        this.evalGrouping = grouping;
    }

    public final NodeDescriptor[] getSources() {
        return this.sources;
    }
}

