/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import org.evrete.api.ReIterator;
import org.evrete.api.RuntimeFact;
import org.evrete.runtime.PlainMemory;
import org.evrete.runtime.RhsFactGroup;
import org.evrete.runtime.RhsFactGroupDescriptor;
import org.evrete.runtime.RuntimeFactTypePlain;
import org.evrete.runtime.RuntimeRuleImpl;
import org.evrete.runtime.ScanMode;

public class RhsFactGroupAlpha
implements RhsFactGroup {
    private final RhsFactGroupDescriptor descriptor;
    private final RuntimeFactTypePlain[] types;
    private final int lastIndex;
    private final RuntimeFact[] state;

    public RhsFactGroupAlpha(RuntimeRuleImpl rule, RhsFactGroupDescriptor descriptor, RuntimeFact[][] factState) {
        this.descriptor = descriptor;
        this.types = (RuntimeFactTypePlain[])rule.resolve(RuntimeFactTypePlain.class, descriptor.getTypes());
        this.state = factState[descriptor.getFactGroupIndex()];
        this.lastIndex = this.types.length - 1;
    }

    @Override
    public boolean isAlpha() {
        return true;
    }

    public boolean hasDelta() {
        for (RuntimeFactTypePlain plain : this.types) {
            if (plain.getSource().deltaIterator().reset() <= 0L) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getIndex() {
        return this.descriptor.getFactGroupIndex();
    }

    public RuntimeFactTypePlain[] getTypes() {
        return this.types;
    }

    void run(ScanMode mode, Runnable r) {
        switch (mode) {
            case DELTA: {
                this.runDelta(0, false, r);
                return;
            }
            case FULL: {
                this.runFull(0, r);
                return;
            }
            case KNOWN: {
                this.runKnown(0, r);
                return;
            }
        }
        throw new IllegalStateException();
    }

    private boolean next(int index, ReIterator<RuntimeFact> it) {
        RuntimeFact fact = (RuntimeFact)it.next();
        if (fact.isDeleted()) {
            it.remove();
            return false;
        }
        this.state[index] = fact;
        return true;
    }

    private void runDelta(int index, boolean hasDelta, Runnable r) {
        block8: {
            PlainMemory memory;
            block7: {
                memory = this.types[index].getSource();
                if (index != this.lastIndex) break block7;
                ReIterator<RuntimeFact> it = memory.mainIterator();
                if (hasDelta && it.reset() > 0L) {
                    while (it.hasNext()) {
                        if (!this.next(index, it)) continue;
                        r.run();
                    }
                }
                if ((it = memory.deltaIterator()).reset() <= 0L) break block8;
                while (it.hasNext()) {
                    if (!this.next(index, it)) continue;
                    r.run();
                }
                break block8;
            }
            ReIterator<RuntimeFact> it = memory.mainIterator();
            if (it.reset() > 0L) {
                while (it.hasNext()) {
                    if (!this.next(index, it)) continue;
                    this.runDelta(index + 1, hasDelta, r);
                }
            }
            if ((it = memory.deltaIterator()).reset() > 0L) {
                while (it.hasNext()) {
                    if (!this.next(index, it)) continue;
                    this.runDelta(index + 1, true, r);
                }
            }
        }
    }

    private void runFull(int index, Runnable r) {
        block8: {
            PlainMemory memory;
            block7: {
                memory = this.types[index].getSource();
                if (index != this.lastIndex) break block7;
                ReIterator<RuntimeFact> it = memory.mainIterator();
                if (it.reset() > 0L) {
                    while (it.hasNext()) {
                        if (!this.next(index, it)) continue;
                        r.run();
                    }
                }
                if ((it = memory.deltaIterator()).reset() <= 0L) break block8;
                while (it.hasNext()) {
                    if (!this.next(index, it)) continue;
                    r.run();
                }
                break block8;
            }
            ReIterator<RuntimeFact> it = memory.mainIterator();
            if (it.reset() > 0L) {
                while (it.hasNext()) {
                    if (!this.next(index, it)) continue;
                    this.runFull(index + 1, r);
                }
            }
            if ((it = memory.deltaIterator()).reset() > 0L) {
                while (it.hasNext()) {
                    if (!this.next(index, it)) continue;
                    this.runFull(index + 1, r);
                }
            }
        }
    }

    private void runKnown(int index, Runnable r) {
        block4: {
            ReIterator<RuntimeFact> it;
            block3: {
                PlainMemory memory = this.types[index].getSource();
                it = memory.mainIterator();
                if (index != this.lastIndex) break block3;
                if (it.reset() <= 0L) break block4;
                while (it.hasNext()) {
                    if (!this.next(index, it)) continue;
                    r.run();
                }
                break block4;
            }
            if (it.reset() > 0L) {
                while (it.hasNext()) {
                    if (!this.next(index, it)) continue;
                    this.runKnown(index + 1, r);
                }
            }
        }
    }
}

