/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import org.evrete.api.Action;
import org.evrete.api.RhsContext;
import org.evrete.api.RuntimeFact;
import org.evrete.runtime.AbstractRuntimeLhs;
import org.evrete.runtime.AggregateLhsDescriptor;
import org.evrete.runtime.LhsDescriptor;
import org.evrete.runtime.RuntimeAggregateLhsJoined;
import org.evrete.runtime.RuntimeLhsAggregate;
import org.evrete.runtime.RuntimeLhsDefault;
import org.evrete.runtime.RuntimeRuleImpl;
import org.evrete.runtime.memory.ActionQueue;
import org.evrete.runtime.memory.BetaEndNode;

public abstract class RuntimeLhs
extends AbstractRuntimeLhs
implements RhsContext {
    private final Collection<BetaEndNode> allBetaEndNodes = new ArrayList<BetaEndNode>();
    private final Function<String, int[]> name2indices;
    private ActionQueue<Object> buffer;
    private final RuntimeRuleImpl rule;

    protected RuntimeLhs(RuntimeRuleImpl rule, LhsDescriptor descriptor) {
        super(rule, descriptor);
        this.name2indices = descriptor.getNameIndices();
        this.allBetaEndNodes.addAll(this.getEndNodes());
        this.rule = rule;
    }

    static RuntimeLhs factory(RuntimeRuleImpl rule, LhsDescriptor descriptor) {
        Set<AggregateLhsDescriptor> aggregates = descriptor.getAggregateDescriptors();
        if (aggregates.isEmpty()) {
            return new RuntimeLhsDefault(rule, descriptor);
        }
        return new RuntimeLhsAggregate(rule, descriptor, aggregates);
    }

    @Override
    public RuntimeRuleImpl getRule() {
        return this.rule;
    }

    protected void addEndNodes(Collection<BetaEndNode> endNodes) {
        this.allBetaEndNodes.addAll(endNodes);
    }

    public abstract Collection<RuntimeAggregateLhsJoined> getAggregateConditionedGroups();

    abstract void forEach(Consumer<RhsContext> var1);

    public void setBuffer(ActionQueue<Object> buffer) {
        this.buffer = buffer;
    }

    public final Collection<BetaEndNode> getAllBetaEndNodes() {
        return this.allBetaEndNodes;
    }

    @Override
    public final RuntimeFact getFact(String name) {
        int[] arr = this.name2indices.apply(name);
        if (arr == null) {
            throw new IllegalArgumentException("Unknown type reference: " + name);
        }
        return this.factState[arr[0]][arr[1]];
    }

    @Override
    public final RhsContext update(Object obj) {
        this.buffer.add(Action.UPDATE, obj);
        return this;
    }

    @Override
    public final RhsContext delete(Object obj) {
        this.buffer.add(Action.RETRACT, obj);
        return this;
    }

    @Override
    public final RhsContext insert(Object obj) {
        this.buffer.add(Action.INSERT, obj);
        return this;
    }
}

