/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.logging.Logger;
import org.evrete.api.KeyMode;
import org.evrete.api.ReIterator;
import org.evrete.api.RhsContext;
import org.evrete.api.ValueRow;
import org.evrete.runtime.LhsDescriptor;
import org.evrete.runtime.RhsFactGroupAlpha;
import org.evrete.runtime.RhsFactGroupBeta;
import org.evrete.runtime.RuntimeAggregateLhsJoined;
import org.evrete.runtime.RuntimeLhs;
import org.evrete.runtime.RuntimeRuleImpl;
import org.evrete.runtime.ScanMode;

public class RuntimeLhsDefault
extends RuntimeLhs
implements RhsContext {
    private static final Collection<RuntimeAggregateLhsJoined> EMPTY_AGGREGATES = Collections.unmodifiableCollection(Collections.emptyList());

    RuntimeLhsDefault(RuntimeRuleImpl rule, LhsDescriptor descriptor) {
        super(rule, descriptor);
    }

    @Override
    public Collection<RuntimeAggregateLhsJoined> getAggregateConditionedGroups() {
        return EMPTY_AGGREGATES;
    }

    @Override
    protected void forEach(Consumer<RhsContext> rhs) {
        this.forEach(() -> rhs.accept(this));
    }

    static void runKeys(ScanMode mode, RhsFactGroupBeta[] groups, Runnable r) {
        switch (mode) {
            case DELTA: {
                RuntimeLhsDefault.runDelta(0, groups.length - 1, false, groups, r);
                return;
            }
            case KNOWN: {
                RuntimeLhsDefault.runKnown(0, groups.length - 1, groups, r);
                return;
            }
            case FULL: {
                RuntimeLhsDefault.runFull(0, groups.length - 1, groups, r);
                return;
            }
        }
        throw new UnsupportedOperationException();
    }

    private static void runDelta(int index, int lastIndex, boolean hasDelta, RhsFactGroupBeta[] groups, Runnable r) {
        RhsFactGroupBeta group = groups[index];
        Set<Map.Entry<KeyMode, ReIterator<ValueRow[]>>> entries = group.keyIterators().entrySet();
        if (index == lastIndex) {
            for (Map.Entry<KeyMode, ReIterator<ValueRow[]>> entry : entries) {
                KeyMode mode = entry.getKey();
                ReIterator<ValueRow[]> iterator = entry.getValue();
                if (!mode.isDeltaMode() && !hasDelta || iterator.reset() <= 0L) continue;
                while (iterator.hasNext()) {
                    if (!group.setKey((ValueRow[])iterator.next())) continue;
                    r.run();
                }
            }
        } else {
            for (Map.Entry<KeyMode, ReIterator<ValueRow[]>> entry : entries) {
                KeyMode mode = entry.getKey();
                ReIterator<ValueRow[]> iterator = entry.getValue();
                if (iterator.reset() <= 0L) continue;
                while (iterator.hasNext()) {
                    if (!group.setKey((ValueRow[])iterator.next())) continue;
                    RuntimeLhsDefault.runDelta(index + 1, lastIndex, mode.isDeltaMode(), groups, r);
                }
            }
        }
    }

    private static void runFull(int index, int lastIndex, RhsFactGroupBeta[] groups, Runnable r) {
        RhsFactGroupBeta group = groups[index];
        Set<Map.Entry<KeyMode, ReIterator<ValueRow[]>>> entries = group.keyIterators().entrySet();
        if (index == lastIndex) {
            for (Map.Entry<KeyMode, ReIterator<ValueRow[]>> entry : entries) {
                ReIterator<ValueRow[]> iterator = entry.getValue();
                if (iterator.reset() <= 0L) continue;
                while (iterator.hasNext()) {
                    if (!group.setKey((ValueRow[])iterator.next())) continue;
                    r.run();
                }
            }
        } else {
            for (Map.Entry<KeyMode, ReIterator<ValueRow[]>> entry : entries) {
                ReIterator<ValueRow[]> iterator = entry.getValue();
                if (iterator.reset() <= 0L) continue;
                while (iterator.hasNext()) {
                    if (!group.setKey((ValueRow[])iterator.next())) continue;
                    RuntimeLhsDefault.runFull(index + 1, lastIndex, groups, r);
                }
            }
        }
    }

    private static void runKnown(int index, int lastIndex, RhsFactGroupBeta[] groups, Runnable r) {
        RhsFactGroupBeta group = groups[index];
        Set<Map.Entry<KeyMode, ReIterator<ValueRow[]>>> entries = group.keyIterators().entrySet();
        if (index == lastIndex) {
            for (Map.Entry<KeyMode, ReIterator<ValueRow[]>> entry : entries) {
                KeyMode mode = entry.getKey();
                ReIterator<ValueRow[]> iterator = entry.getValue();
                if (mode.isDeltaMode() || iterator.reset() <= 0L) continue;
                while (iterator.hasNext()) {
                    if (!group.setKey((ValueRow[])iterator.next())) continue;
                    r.run();
                }
            }
        } else {
            for (Map.Entry<KeyMode, ReIterator<ValueRow[]>> entry : entries) {
                KeyMode mode = entry.getKey();
                ReIterator<ValueRow[]> iterator = entry.getValue();
                if (iterator.reset() <= 0L || mode.isDeltaMode()) continue;
                while (iterator.hasNext()) {
                    if (!group.setKey((ValueRow[])iterator.next())) continue;
                    RuntimeLhsDefault.runKnown(index + 1, lastIndex, groups, r);
                }
            }
        }
    }

    private void forEach(Runnable eachFactRunnable) {
        RhsFactGroupAlpha alphaGroup = this.getAlphaFactGroup();
        RhsFactGroupBeta[] betaGroups = this.getBetaFactGroups();
        if (alphaGroup != null) {
            boolean hasAlphaDelta = alphaGroup.hasDelta();
            if (betaGroups.length > 0) {
                if (hasAlphaDelta) {
                    RuntimeLhsDefault.runKeys(ScanMode.KNOWN, betaGroups, () -> RhsFactGroupBeta.runCurrentFacts(betaGroups, () -> alphaGroup.run(ScanMode.DELTA, eachFactRunnable)));
                    RuntimeLhsDefault.runKeys(ScanMode.DELTA, betaGroups, () -> RhsFactGroupBeta.runCurrentFacts(betaGroups, () -> alphaGroup.run(ScanMode.KNOWN, eachFactRunnable)));
                    RuntimeLhsDefault.runKeys(ScanMode.DELTA, betaGroups, () -> RhsFactGroupBeta.runCurrentFacts(betaGroups, () -> alphaGroup.run(ScanMode.DELTA, eachFactRunnable)));
                } else {
                    RuntimeLhsDefault.runKeys(ScanMode.DELTA, betaGroups, () -> RhsFactGroupBeta.runCurrentFacts(betaGroups, () -> alphaGroup.run(ScanMode.FULL, eachFactRunnable)));
                }
            } else {
                alphaGroup.run(ScanMode.DELTA, eachFactRunnable);
            }
        } else if (betaGroups.length > 0) {
            RuntimeLhsDefault.runKeys(ScanMode.DELTA, betaGroups, () -> RhsFactGroupBeta.runCurrentFacts(betaGroups, eachFactRunnable));
        } else {
            Logger.getAnonymousLogger().warning("No output groups");
        }
    }
}

