/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime.evaluation;

import java.util.function.Function;
import org.evrete.api.ComplexityObject;
import org.evrete.api.Evaluator;
import org.evrete.api.IntToValue;
import org.evrete.api.LogicallyComparable;
import org.evrete.api.NamedType;
import org.evrete.api.TypeField;
import org.evrete.runtime.FactType;
import org.evrete.runtime.FactTypeField;
import org.evrete.runtime.builder.FieldReference;

public class EvaluatorInternal
implements ComplexityObject,
LogicallyComparable {
    public static final EvaluatorInternal[] ZERO_ARRAY = new EvaluatorInternal[0];
    private final Evaluator delegate;
    private final FactTypeField[] descriptor;

    public EvaluatorInternal(Evaluator delegate, Function<NamedType, FactType> typeFunction) {
        this.delegate = delegate;
        this.descriptor = new FactTypeField[delegate.descriptor().length];
        for (int ref = 0; ref < delegate.descriptor().length; ++ref) {
            FieldReference fieldReference = delegate.descriptor()[ref];
            FactType factType = typeFunction.apply(fieldReference.type());
            TypeField field = fieldReference.field();
            this.descriptor[ref] = new FactTypeField(factType, field);
        }
    }

    public FactTypeField[] descriptor() {
        return this.descriptor;
    }

    public Evaluator getDelegate() {
        return this.delegate;
    }

    public boolean test(IntToValue values) {
        return this.delegate.test(values);
    }

    @Override
    public int compare(LogicallyComparable other) {
        return this.delegate.compare(other);
    }

    @Override
    public double getComplexity() {
        return this.delegate.getComplexity();
    }

    public String toString() {
        return this.delegate.toString();
    }
}

