/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime.memory;

import org.evrete.api.Action;

public class ActionCounter {
    private final int[] counts = new int[Action.values().length];

    public ActionCounter() {
        this.reset();
    }

    public void increment(Action action) {
        int n = action.ordinal();
        this.counts[n] = this.counts[n] + 1;
    }

    public boolean hasActions(Action ... actions) {
        for (Action a : actions) {
            if (this.counts[a.ordinal()] <= 0) continue;
            return true;
        }
        return false;
    }

    public boolean hasAction(Action action) {
        return this.counts[action.ordinal()] > 0;
    }

    void reset() {
        for (Action action : Action.values()) {
            this.reset(action);
        }
    }

    void reset(Action action) {
        this.counts[action.ordinal()] = 0;
    }
}

