/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime.memory;

import java.util.EnumMap;
import java.util.Map;
import java.util.function.BiConsumer;
import org.evrete.api.Action;
import org.evrete.api.ReIterable;
import org.evrete.api.ReIterator;
import org.evrete.collections.LinearIdentityHashSet;

public class ActionQueue<T> {
    private final EnumMap<Action, LinearIdentityHashSet<T>> data = new EnumMap(Action.class);

    public ActionQueue() {
        for (Action action : Action.values()) {
            this.data.put(action, new LinearIdentityHashSet());
        }
    }

    public void add(Action action, T o) {
        if (o != null) {
            this.data.get((Object)action).add(o);
        }
    }

    public void clear() {
        for (Action action : Action.values()) {
            this.clear(action);
        }
    }

    public void clear(Action action) {
        this.data.get((Object)action).clear();
    }

    public void fillFrom(ActionQueue<T> other) {
        for (Map.Entry<Action, LinearIdentityHashSet<T>> entry : other.data.entrySet()) {
            this.data.get((Object)entry.getKey()).bulkAdd(entry.getValue());
        }
    }

    public boolean isEmpty() {
        for (LinearIdentityHashSet<T> queue : this.data.values()) {
            if (queue.size() <= 0) continue;
            return false;
        }
        return true;
    }

    public boolean hasActions(Action ... actions) {
        for (Action action : actions) {
            if (this.data.get((Object)action).size() <= 0) continue;
            return true;
        }
        return false;
    }

    public ReIterator<T> get(Action action) {
        return this.data.get((Object)action).iterator();
    }

    public void forEach(BiConsumer<? super Action, ? super ReIterable<T>> action) {
        this.data.forEach(action);
    }

    public String toString() {
        return this.data.toString();
    }
}

