/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime.memory;

import org.evrete.api.FieldsKey;
import org.evrete.api.Memory;
import org.evrete.api.ReIterable;
import org.evrete.api.ReIterator;
import org.evrete.api.RuntimeFact;
import org.evrete.api.SharedBetaFactStorage;
import org.evrete.runtime.evaluation.AlphaBucketMeta;
import org.evrete.runtime.memory.SessionMemory;

class FieldsMemoryBucket
implements Memory {
    private final SharedBetaFactStorage fieldData;
    private final AlphaBucketMeta alphaMask;

    FieldsMemoryBucket(SessionMemory runtime, FieldsKey typeFields, AlphaBucketMeta alphaMask) {
        this.alphaMask = alphaMask;
        this.fieldData = runtime.newSharedKeyStorage(typeFields);
    }

    public void clear() {
        this.fieldData.clear();
    }

    SharedBetaFactStorage getFieldData() {
        return this.fieldData;
    }

    @Override
    public void commitChanges() {
        this.fieldData.commitChanges();
    }

    void insert(ReIterable<? extends RuntimeFact> facts) {
        ReIterator<? extends RuntimeFact> it = facts.iterator();
        int size = (int)it.reset();
        if (size == 0) {
            return;
        }
        this.fieldData.ensureDeltaCapacity(size);
        while (it.hasNext()) {
            this.insert((RuntimeFact)it.next());
        }
    }

    private void insert(RuntimeFact fact) {
        if (this.alphaMask.test(fact)) {
            this.fieldData.insert(fact);
        }
    }

    void delete(ReIterable<? extends RuntimeFact> facts) {
        ReIterator<? extends RuntimeFact> it = facts.iterator();
        while (it.hasNext()) {
            this.delete((RuntimeFact)it.next());
        }
    }

    void delete(RuntimeFact fact) {
        if (this.alphaMask.test(fact)) {
            this.fieldData.delete(fact);
        }
    }

    public String toString() {
        return this.fieldData.toString();
    }
}

