/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime.memory;

import java.util.function.IntFunction;
import java.util.function.Supplier;
import org.evrete.api.IntToValue;
import org.evrete.api.IntToValueRow;
import org.evrete.api.KeysStore;
import org.evrete.api.ReIterator;
import org.evrete.api.ValueRow;
import org.evrete.runtime.ConditionNodeDescriptor;
import org.evrete.runtime.FactType;
import org.evrete.runtime.FactTypeField;
import org.evrete.runtime.RuntimeListeners;
import org.evrete.runtime.evaluation.EvaluatorGroup;
import org.evrete.runtime.evaluation.EvaluatorInternal;
import org.evrete.runtime.memory.BetaConditionNode;
import org.evrete.runtime.memory.BetaMemoryNode;
import org.evrete.runtime.memory.NodeIterationStateFactory;

public class NodeIterationState
implements NodeIterationStateFactory.State {
    private final KeysStore.Entry[][] state;
    private final IntFunction<IntToValueRow> destinationValues;
    private final int[] nonPlainIndices;
    private final ReIterator<KeysStore.Entry>[] secondary;
    private final EvaluatorDelegate[] evaluators;

    public NodeIterationState(BetaConditionNode node, int[][][] locationData) {
        BetaMemoryNode<?>[] sources = node.getSources();
        RuntimeListeners listeners = node.getRuntime().getListeners();
        this.nonPlainIndices = node.getNonPlainSourceIndices();
        if (this.nonPlainIndices.length == 0) {
            this.state = new KeysStore.Entry[1][];
        } else {
            this.state = new KeysStore.Entry[2][];
            this.state[1] = new KeysStore.Entry[this.nonPlainIndices.length];
        }
        this.state[0] = new KeysStore.Entry[sources.length];
        this.destinationValues = new DestinationValueAdapter(this.state, locationData);
        this.secondary = new ReIterator[this.nonPlainIndices.length];
        EvaluatorGroup inner = node.getDescriptor().getExpression();
        EvaluatorInternal[] delegates = inner.getEvaluators();
        this.evaluators = new EvaluatorDelegate[delegates.length];
        for (int i = 0; i < this.evaluators.length; ++i) {
            EvaluatorDelegate delegate = listeners.containsConditionTestListener() ? new Verbose(delegates[i], this.state[0], node, listeners) : new Muted(delegates[i], this.state[0], node);
            this.evaluators[i] = delegate;
        }
    }

    @Override
    public void saveTo(KeysStore destination) {
        destination.save(this.destinationValues);
    }

    @Override
    public boolean evaluate() {
        for (EvaluatorDelegate ed : this.evaluators) {
            if (ed.test()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void setEvaluationEntry(KeysStore.Entry entry, int sourceId) {
        this.state[0][sourceId] = entry;
    }

    @Override
    public void setSecondaryEntry(KeysStore.Entry entry, int nonPlainIndex) {
        this.state[1][nonPlainIndex] = entry;
    }

    @Override
    public ReIterator<KeysStore.Entry>[] buildSecondary() {
        for (int i = 0; i < this.nonPlainIndices.length; ++i) {
            int sourceId = this.nonPlainIndices[i];
            this.secondary[i] = this.state[0][sourceId].getNext().entries();
        }
        return this.secondary;
    }

    private static class DestinationValueAdapter
    implements IntFunction<IntToValueRow> {
        private final LevelMapper[] levelMappers;

        DestinationValueAdapter(KeysStore.Entry[][] currentState, int[][][] locationData) {
            this.levelMappers = new LevelMapper[locationData.length];
            for (int level = 0; level < locationData.length; ++level) {
                this.levelMappers[level] = new LevelMapper(currentState, locationData[level]);
            }
        }

        @Override
        public IntToValueRow apply(int level) {
            return this.levelMappers[level];
        }

        private static class LevelMapper
        implements IntToValueRow {
            private final KeysStore.Entry[][] currentState;
            private final int[][] locations;

            LevelMapper(KeysStore.Entry[][] currentState, int[][] locations) {
                this.currentState = currentState;
                this.locations = locations;
            }

            @Override
            public ValueRow apply(int typeArrIndex) {
                int[] addr = this.locations[typeArrIndex];
                return this.currentState[addr[0]][addr[1]].key()[addr[2]];
            }
        }
    }

    private static abstract class EvaluatorDelegate {
        final EvaluatorInternal evaluator;
        final IntToValue mappedValues;
        final ValueSupplier[] values;
        final BetaConditionNode node;

        EvaluatorDelegate(EvaluatorInternal evaluator, KeysStore.Entry[] state, BetaConditionNode node) {
            this.evaluator = evaluator;
            this.node = node;
            this.values = new ValueSupplier[evaluator.descriptor().length];
            for (int refId2 = 0; refId2 < evaluator.descriptor().length; ++refId2) {
                FactTypeField ref = evaluator.descriptor()[refId2];
                FactType type = ref.getFactType();
                int fieldIndex = ref.getFieldIndex();
                ConditionNodeDescriptor.TypeLocator loc = node.getDescriptor().locate(type);
                assert (loc.level == 0);
                int sourceIndex = loc.source;
                int factIndex = loc.position;
                this.values[refId2] = new ValueSupplier(state, sourceIndex, factIndex, fieldIndex);
            }
            this.mappedValues = refId -> this.values[refId].get();
        }

        abstract boolean test();

        public String toString() {
            return "EvaluatorDelegate{evaluator=" + this.evaluator + '}';
        }
    }

    private static class Verbose
    extends EvaluatorDelegate {
        private final RuntimeListeners listeners;

        Verbose(EvaluatorInternal evaluator, KeysStore.Entry[] state, BetaConditionNode node, RuntimeListeners listeners) {
            super(evaluator, state, node);
            this.listeners = listeners;
        }

        @Override
        boolean test() {
            boolean b = this.evaluator.test(this.mappedValues);
            this.listeners.fireConditionTestResult(this.node, this.evaluator.getDelegate(), this.mappedValues, b);
            return b;
        }
    }

    private static class Muted
    extends EvaluatorDelegate {
        Muted(EvaluatorInternal evaluator, KeysStore.Entry[] state, BetaConditionNode node) {
            super(evaluator, state, node);
        }

        @Override
        boolean test() {
            return this.evaluator.test(this.mappedValues);
        }
    }

    private static class ValueSupplier
    implements Supplier<Object> {
        private final KeysStore.Entry[] state;
        private final int sourceId;
        private final int typeId;
        private final int fieldId;

        ValueSupplier(KeysStore.Entry[] state, int sourceId, int typeId, int fieldId) {
            this.state = state;
            this.sourceId = sourceId;
            this.typeId = typeId;
            this.fieldId = fieldId;
        }

        @Override
        public Object get() {
            return this.state[this.sourceId].key()[this.typeId].get(this.fieldId);
        }
    }
}

