/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime.memory;

import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.logging.Logger;
import org.evrete.api.Action;
import org.evrete.api.ActiveField;
import org.evrete.api.FieldsKey;
import org.evrete.api.ReIterator;
import org.evrete.api.RuntimeFact;
import org.evrete.api.SharedPlainFactStorage;
import org.evrete.api.Type;
import org.evrete.collections.ArrayOf;
import org.evrete.runtime.PlainMemory;
import org.evrete.runtime.RuntimeFactImpl;
import org.evrete.runtime.evaluation.AlphaBucketMeta;
import org.evrete.runtime.evaluation.AlphaConditions;
import org.evrete.runtime.evaluation.AlphaDelta;
import org.evrete.runtime.evaluation.AlphaEvaluator;
import org.evrete.runtime.memory.FieldsMemory;
import org.evrete.runtime.memory.SessionMemory;
import org.evrete.runtime.memory.TypeMemoryBase;
import org.evrete.runtime.memory.TypeMemoryBucket;

public final class TypeMemory
extends TypeMemoryBase {
    private static final Logger LOGGER = Logger.getLogger(TypeMemory.class.getName());
    private final AlphaConditions alphaConditions;
    private final Map<FieldsKey, FieldsMemory> betaMemories = new HashMap<FieldsKey, FieldsMemory>();
    private final ArrayOf<TypeMemoryBucket> alphaBuckets;
    private final EnumMap<Action, SharedPlainFactStorage> inputBuffer = new EnumMap(Action.class);

    TypeMemory(SessionMemory runtime, Type<?> type) {
        super(runtime, type);
        for (Action action : Action.values()) {
            this.inputBuffer.put(action, runtime.newSharedPlainStorage());
        }
        this.alphaConditions = runtime.getAlphaConditions();
        this.alphaBuckets = new ArrayOf<TypeMemoryBucket>(new TypeMemoryBucket[]{new TypeMemoryBucket(runtime, AlphaBucketMeta.NO_FIELDS_NO_CONDITIONS)});
    }

    public final Set<FieldsKey> knownFieldSets() {
        return Collections.unmodifiableSet(this.betaMemories.keySet());
    }

    public void propagateBetaDeltas() {
        SharedPlainFactStorage inserts = this.inputBuffer.get((Object)Action.INSERT);
        for (TypeMemoryBucket bucket : (TypeMemoryBucket[])this.alphaBuckets.data) {
            bucket.insert(inserts);
        }
        for (FieldsMemory fm : this.betaMemories.values()) {
            fm.insert(this.inputBuffer.get((Object)Action.INSERT));
        }
        inserts.clear();
    }

    public RuntimeFact doInsert(Object o) {
        RuntimeFactImpl fact = this.create(o);
        this.inputBuffer.get((Object)Action.INSERT).insert(fact);
        return fact;
    }

    public RuntimeFact doDelete(Object o) {
        RuntimeFact fact = this.find(o);
        if (fact != null) {
            this.inputBuffer.get((Object)Action.RETRACT).insert(fact);
            return fact;
        }
        LOGGER.warning("Object " + o + " hasn't been previously inserted");
        return null;
    }

    RuntimeFact find(Object o) {
        RuntimeFact fact = this.main0().find(o);
        if (fact == null) {
            fact = this.delta0().find(o);
        }
        return fact;
    }

    void clear() {
        for (TypeMemoryBucket bucket : (TypeMemoryBucket[])this.alphaBuckets.data) {
            bucket.clear();
        }
        for (FieldsMemory fm : this.betaMemories.values()) {
            fm.clear();
        }
        this.inputBuffer.clear();
    }

    public final FieldsMemory get(FieldsKey fields) {
        FieldsMemory fm = this.betaMemories.get(fields);
        if (fm == null) {
            throw new IllegalArgumentException("No key memory exists for " + fields);
        }
        return fm;
    }

    public void commitDeltas() {
        for (TypeMemoryBucket bucket : (TypeMemoryBucket[])this.alphaBuckets.data) {
            bucket.commitChanges();
        }
        for (FieldsMemory fm : this.betaMemories.values()) {
            fm.commitDeltas();
        }
    }

    public void performDelete() {
        SharedPlainFactStorage deleteSubject = this.inputBuffer.get((Object)Action.RETRACT);
        ReIterator it = deleteSubject.iterator();
        while (it.hasNext()) {
            RuntimeFactImpl impl = (RuntimeFactImpl)it.next();
            impl.setDeleted(true);
        }
        for (TypeMemoryBucket bucket : (TypeMemoryBucket[])this.alphaBuckets.data) {
            bucket.retract(deleteSubject);
        }
        for (FieldsMemory fm : this.betaMemories.values()) {
            fm.retract(deleteSubject);
        }
        deleteSubject.clear();
    }

    public PlainMemory get(AlphaBucketMeta alphaMask) {
        return this.alphaBuckets.getChecked(alphaMask.getBucketIndex());
    }

    void touchMemory(FieldsKey key, AlphaBucketMeta alphaMeta) {
        if (key.size() == 0) {
            this.touchAlphaMemory(alphaMeta);
        } else {
            this.betaMemories.computeIfAbsent(key, k -> new FieldsMemory((SessionMemory)this.getRuntime(), key)).touchMemory(alphaMeta);
        }
    }

    private TypeMemoryBucket touchAlphaMemory(AlphaBucketMeta alphaMeta) {
        int bucketIndex;
        if (!alphaMeta.isEmpty() && this.alphaBuckets.isEmptyAt(bucketIndex = alphaMeta.getBucketIndex())) {
            TypeMemoryBucket newBucket = new TypeMemoryBucket((SessionMemory)this.getRuntime(), alphaMeta);
            this.alphaBuckets.set(bucketIndex, newBucket);
            return newBucket;
        }
        return null;
    }

    void onNewAlphaBucket(AlphaDelta delta) {
        if (this.inputBuffer.get((Object)Action.INSERT).size() > 0) {
            throw new UnsupportedOperationException("A new condition was created in an uncommitted memory.");
        }
        ReIterator existingFacts = this.main0().iterator();
        AlphaEvaluator[] newEvaluators = delta.getNewEvaluators();
        if (newEvaluators.length > 0 && existingFacts.reset() > 0L) {
            while (existingFacts.hasNext()) {
                RuntimeFactImpl fact = (RuntimeFactImpl)existingFacts.next();
                fact.appendAlphaTest(newEvaluators);
            }
        }
        FieldsKey key = delta.getKey();
        AlphaBucketMeta alphaMeta = delta.getNewAlphaMeta();
        if (key.size() == 0) {
            TypeMemoryBucket newBucket = this.touchAlphaMemory(alphaMeta);
            assert (newBucket != null);
            newBucket.fillMainStorage(existingFacts);
        } else {
            this.betaMemories.computeIfAbsent(key, k -> new FieldsMemory((SessionMemory)this.getRuntime(), key)).onNewAlphaBucket(alphaMeta, existingFacts);
        }
        this.cachedAlphaEvaluators = (AlphaEvaluator[])this.alphaConditions.getPredicates(this.type).data;
    }

    final <T> void forEachMemoryObject(Consumer<T> consumer) {
        this.main0().iterator().forEachRemaining(fact -> {
            if (!fact.isDeleted()) {
                consumer.accept(fact.getDelegate());
            }
        });
    }

    final void forEachObjectUnchecked(Consumer<Object> consumer) {
        this.main0().iterator().forEachRemaining(fact -> {
            if (!fact.isDeleted()) {
                consumer.accept(fact.getDelegate());
            }
        });
    }

    private SharedPlainFactStorage main0() {
        return ((TypeMemoryBucket[])this.alphaBuckets.data)[0].getData();
    }

    private SharedPlainFactStorage delta0() {
        return ((TypeMemoryBucket[])this.alphaBuckets.data)[0].getDelta();
    }

    private RuntimeFactImpl create(Object o) {
        Object[] values = new Object[this.cachedActiveFields.length];
        for (int i = 0; i < this.cachedActiveFields.length; ++i) {
            values[i] = this.cachedActiveFields[i].readValue(o);
        }
        if (this.cachedAlphaEvaluators.length > 0) {
            boolean[] alphaTests = new boolean[this.cachedAlphaEvaluators.length];
            for (AlphaEvaluator alpha : this.cachedAlphaEvaluators) {
                int fieldInUseIndex = alpha.getValueIndex();
                alphaTests[alpha.getUniqueId()] = alpha.test(values[fieldInUseIndex]);
            }
            return RuntimeFactImpl.factory(o, values, alphaTests);
        }
        return RuntimeFactImpl.factory(o, values);
    }

    final void onNewActiveField(ActiveField newField) {
        for (SharedPlainFactStorage storage : new SharedPlainFactStorage[]{this.main0(), this.delta0()}) {
            ReIterator it = storage.iterator();
            while (it.hasNext()) {
                RuntimeFactImpl rto = (RuntimeFactImpl)it.next();
                Object fieldValue = newField.readValue(rto.getDelegate());
                rto.appendValue(newField, fieldValue);
            }
        }
        this.cachedActiveFields = ((SessionMemory)this.getRuntime()).getActiveFields(this.type);
    }

    public String toString() {
        return "TypeMemory{alphaBuckets=" + this.alphaBuckets + '}';
    }
}

