/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime.memory;

import java.util.function.Consumer;
import org.evrete.api.ReIterator;
import org.evrete.api.RuntimeFact;
import org.evrete.runtime.RuntimeFactImpl;
import org.evrete.runtime.memory.BiMemoryComponent;
import org.evrete.runtime.memory.IdentityMap;
import org.evrete.runtime.memory.MemoryScope;

public class TypeMemoryComponent
implements BiMemoryComponent<TypeMemoryComponent> {
    private final IdentityMap map = new IdentityMap();
    private final MemoryScope scope;

    public TypeMemoryComponent(MemoryScope scope) {
        this.scope = scope;
    }

    @Override
    public void addAll(TypeMemoryComponent other) {
        this.map.bulkAdd(other.map);
    }

    @Override
    public void clearData() {
        this.map.clear();
    }

    public ReIterator<RuntimeFact> iterator() {
        return this.map.factIterator();
    }

    public boolean contains(Object o) {
        return this.map.contains(o);
    }

    public boolean hasData() {
        return this.map.size() > 0;
    }

    public int totalFacts() {
        return this.map.size();
    }

    public RuntimeFact remove(Object key) {
        return (RuntimeFact)this.map.remove(key);
    }

    public void put(Object key, RuntimeFactImpl value) {
        this.map.put(key, value);
    }

    public final <T> void forEachMemoryObject(Consumer<T> consumer) {
        this.map.forEachKey(f -> consumer.accept(f));
    }

    public final void forEachObjectUnchecked(Consumer<Object> consumer) {
        this.map.forEachKey(consumer);
    }

    public String toString() {
        return "{scope=" + (Object)((Object)this.scope) + ", map=" + this.map + '}';
    }
}

