/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.spi.minimal;

import java.util.Collection;
import java.util.StringJoiner;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.evrete.api.RhsContext;
import org.evrete.api.RuntimeContext;
import org.evrete.api.spi.LiteralRhsCompiler;
import org.evrete.runtime.FactType;
import org.evrete.spi.minimal.AbstractLiteralRhs;
import org.evrete.spi.minimal.JcCompiler;
import org.evrete.spi.minimal.LastServiceProvider;

public class DefaultLiteralRhsProvider
extends LastServiceProvider
implements LiteralRhsCompiler {
    private static final AtomicInteger classCounter = new AtomicInteger(0);
    private static final String classPackage = DefaultLiteralRhsProvider.class.getPackage().getName() + ".rhs";

    @Override
    public Consumer<RhsContext> compileRhs(RuntimeContext<?> requester, String literalRhs, Collection<FactType> factTypes, Collection<String> imports) {
        FactType[] types = factTypes.toArray(FactType.ZERO_ARRAY);
        Class<? extends AbstractLiteralRhs> clazz = this.buildClass(requester.getClassLoader(), types, literalRhs, imports);
        try {
            return clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to initialize RHS", e);
        }
    }

    private Class<? extends AbstractLiteralRhs> buildClass(ClassLoader classLoader, FactType[] types, String literalRhs, Collection<String> imports) {
        JcCompiler compiler = new JcCompiler(classLoader);
        String className = "Rhs" + classCounter.getAndIncrement();
        String source = this.buildSource(className, types, literalRhs, imports);
        return compiler.compile(className, source);
    }

    String buildSource(String className, FactType[] types, String literalRhs, Collection<String> imports) {
        StringJoiner methodArgs = new StringJoiner(", ");
        StringJoiner args = new StringJoiner(", ");
        for (FactType t : types) {
            methodArgs.add(t.getType().getJavaType().getName() + " " + t.getVar());
            args.add(t.getVar());
        }
        StringBuilder sb = new StringBuilder();
        sb.append("package ").append(classPackage).append(";\n\n");
        if (!imports.isEmpty()) {
            for (String imp : imports) {
                String s = imp.replaceAll("\\s", "").replaceAll(";", "");
                sb.append("import ").append(s).append(";\n");
            }
            sb.append("\n");
        }
        sb.append("public class ").append(className).append(" extends ").append(AbstractLiteralRhs.class.getName()).append(" {\n\n");
        sb.append("\t@").append(Override.class.getName()).append("\n");
        sb.append("\tprotected void doRhs() {\n");
        for (FactType t : types) {
            sb.append("\t\t").append(t.getType().getJavaType().getName()).append(" ").append(t.getVar()).append(" = ").append("get(\"").append(t.getVar()).append("\");\n");
        }
        sb.append("\t\tdoRhs(").append(args).append(");\n");
        sb.append("\t}\n\n");
        sb.append("\tprivate void doRhs(").append(methodArgs).append(") {\n");
        sb.append("\t\t/***** Start RHS source *****/\n");
        sb.append(literalRhs).append("\n");
        sb.append("\t\t/****** End RHS source ******/\n");
        sb.append("\t}\n");
        sb.append("}\n");
        return sb.toString();
    }
}

