/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.spi.minimal;

import java.util.Arrays;
import java.util.EnumMap;
import java.util.function.BiPredicate;
import org.evrete.api.ActiveField;
import org.evrete.api.FieldToValue;
import org.evrete.api.FieldsKey;
import org.evrete.api.KeyMode;
import org.evrete.api.ReIterable;
import org.evrete.api.RuntimeFact;
import org.evrete.api.SharedBetaFactStorage;
import org.evrete.api.ValueRow;
import org.evrete.spi.minimal.FieldsFactMap;
import org.evrete.spi.minimal.MiscUtils;
import org.evrete.spi.minimal.ValueRowImpl;

class SharedBetaData
implements SharedBetaFactStorage {
    private final Object[] reusableValueArr;
    private final FieldsFactMap deltaNewKeys = new FieldsFactMap();
    private final FieldsFactMap deltaKnownKeys = new FieldsFactMap();
    private final FieldsFactMap main = new FieldsFactMap();
    private final ActiveField[] fields;
    private final EnumMap<KeyMode, ReIterable<ValueRow>> keyIterables;
    private final BiPredicate<ValueRowImpl, Object[]> SHARED_ARRAY_EQ = new BiPredicate<ValueRowImpl, Object[]>(){

        @Override
        public boolean test(ValueRowImpl entry, Object[] values) {
            return !entry.isDeleted() && MiscUtils.sameData(entry.data, SharedBetaData.this.reusableValueArr);
        }
    };

    SharedBetaData(FieldsKey typeFields) {
        this.fields = typeFields.getFields();
        this.reusableValueArr = new Object[this.fields.length];
        this.keyIterables = this.buildKeyIterables();
    }

    @Override
    public EnumMap<KeyMode, ReIterable<ValueRow>> keyIterables() {
        return this.keyIterables;
    }

    private EnumMap<KeyMode, ReIterable<ValueRow>> buildKeyIterables() {
        EnumMap<KeyMode, ReIterable<ValueRow>> map = new EnumMap<KeyMode, ReIterable<ValueRow>>(KeyMode.class);
        for (KeyMode mode : KeyMode.values()) {
            ReIterable iterator;
            switch (mode) {
                case KNOWN_KEYS_KNOWN_FACTS: {
                    iterator = this.main::keyIterator;
                    break;
                }
                case KNOWN_KEYS_NEW_FACTS: {
                    iterator = this.deltaKnownKeys::keyIterator;
                    break;
                }
                case NEW_KEYS_NEW_FACTS: {
                    iterator = this.deltaNewKeys::keyIterator;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            map.put(mode, iterator);
        }
        return map;
    }

    @Override
    public void clear() {
        this.deltaNewKeys.clear();
        this.deltaKnownKeys.clear();
        this.main.clear();
    }

    private int hash(FieldToValue key) {
        int hash = 0;
        for (int i = 0; i < this.fields.length; ++i) {
            this.reusableValueArr[i] = key.apply(this.fields[i]);
            hash ^= this.reusableValueArr[i].hashCode();
        }
        return hash;
    }

    @Override
    public void ensureDeltaCapacity(int insertCount) {
        this.deltaNewKeys.resize(this.deltaNewKeys.size() + insertCount);
        this.deltaKnownKeys.resize(this.deltaKnownKeys.size() + insertCount);
    }

    @Override
    public void delete(RuntimeFact fact) {
        assert (fact.isDeleted());
        int hash = this.hash(fact);
        int addr = this.main.findBinIndex(this.reusableValueArr, hash, this.SHARED_ARRAY_EQ);
        this.main.remove(fact, addr);
    }

    @Override
    public void commitChanges() {
        this.main.addAll(this.deltaNewKeys);
        this.main.addAll(this.deltaKnownKeys);
        this.deltaNewKeys.clear();
        this.deltaKnownKeys.clear();
    }

    private void insertInner(RuntimeFact fact) {
        int hash = this.hash(fact);
        int addr = this.main.findBinIndex(this.reusableValueArr, hash, this.SHARED_ARRAY_EQ);
        ValueRowImpl key = (ValueRowImpl)this.main.get(addr);
        if (key == null) {
            this.insertTo(hash, fact, this.deltaNewKeys);
        } else {
            this.insertTo(hash, fact, this.deltaKnownKeys);
        }
    }

    private void insertTo(int hash, RuntimeFact fact, FieldsFactMap destination) {
        int addr = destination.findBinIndex(this.reusableValueArr, hash, this.SHARED_ARRAY_EQ);
        ValueRowImpl key = (ValueRowImpl)destination.get(addr);
        if (key == null) {
            ValueRowImpl vr = new ValueRowImpl(Arrays.copyOf(this.reusableValueArr, this.reusableValueArr.length), hash, fact);
            destination.saveDirect(vr, addr);
        } else {
            key.addFact(fact);
        }
    }

    @Override
    public void insert(RuntimeFact fact) {
        this.insertInner(fact);
    }

    public String toString() {
        return "{main=" + this.main + ", kNew=" + this.deltaNewKeys + ", kOld=" + this.deltaKnownKeys + '}';
    }
}

