/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.spi.minimal;

import java.util.Arrays;
import org.evrete.api.ReIterator;
import org.evrete.api.RuntimeFact;
import org.evrete.api.ValueRow;
import org.evrete.collections.LinearIdentityHashSet;
import org.evrete.spi.minimal.MiscUtils;

class ValueRowImpl
implements ValueRow {
    final Object[] data;
    private final LinearIdentityHashSet<RuntimeFact> facts = new LinearIdentityHashSet();
    private final int hash;
    private final ReIterator<RuntimeFact> delegate;
    private int factCount = 0;
    private boolean deleted;

    ValueRowImpl(Object[] data, int hash, RuntimeFact fact) {
        this(data, hash);
        this.addFact(fact);
    }

    ValueRowImpl(Object[] data, int hash) {
        this.data = data;
        this.hash = hash;
        this.delegate = this.facts.iterator();
    }

    void mergeDataFrom(ValueRowImpl other) {
        this.facts.bulkAdd(other.facts);
    }

    void addFact(RuntimeFact fact) {
        this.facts.add(fact);
        ++this.factCount;
    }

    long removeFact(RuntimeFact fact) {
        assert (fact.isDeleted());
        --this.factCount;
        return this.factCount;
    }

    @Override
    public boolean isDeleted() {
        return this.deleted;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    @Override
    public long reset() {
        return this.delegate.reset();
    }

    @Override
    public boolean hasNext() {
        return this.delegate.hasNext();
    }

    @Override
    public RuntimeFact next() {
        return (RuntimeFact)this.delegate.next();
    }

    @Override
    public void remove() {
        this.delegate.remove();
    }

    @Override
    public ReIterator<RuntimeFact> iterator() {
        return this.facts.iterator();
    }

    public String toString() {
        if (this.deleted) {
            return Arrays.toString(this.data) + " -X-> " + this.facts;
        }
        return Arrays.toString(this.data) + " ---> " + this.facts;
    }

    @Override
    public Object get(int i) {
        return this.data[i];
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ValueRowImpl other = (ValueRowImpl)o;
        return MiscUtils.sameData(other.data, this.data);
    }

    public final int hashCode() {
        return this.hash;
    }
}

